<?php 

require_once "vendor/autoload.php";

use Aws\Sns\SnsClient;

class SNSPush {

    const GCM_ARN = "arn:aws:sns:us-west-2:634381625056:app/GCM/Ooly";
    const APNS_ARN = "arn:aws:sns:us-west-2:634381625056:app/APNS/Ooly";
    const REGION = "us-west-2";
    const PLATFORM_PUBLISH = 1;
    const TOPIC_PUBLISH = 2;

    private $topicARN;
    private $sns;
    private $protocol;

    public function __construct($topicARN="", $protocol="")
    {
        $this->topicARN = $topicARN;
        $this->protocol = $protocol;
        $this->sns = SnsClient::factory(array(
            'credentials' => array(
                'key'    => "AKIAIHDZ3QMFHRNPGIMQ",
                'secret' => "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",
            ),
            'region' => self::REGION,
            'version'=> 'latest'
        ));
    }

    public function addDeviceEndPoint($deviceToken, $deviceType,$userData="")
    {
        if ( $deviceType == "android" ) {
            $platformApplicationArn = self::GCM_ARN;
        } elseif ( $deviceType == "ios" ) {
            $platformApplicationArn = self::APNS_ARN;
        } else {
            return false;
        }

        try {
            $result = $this->sns->createPlatformEndpoint(array(
                'PlatformApplicationArn' => $platformApplicationArn,
                'CustomUserData'=>$userData,
                'Token' => $deviceToken,
            ));
            return [
                "success" => true,
                "message" => "OK",
                "result" => $result
            ];
        } catch (\Exception $error) {
            return [
                "success" => false,
                "message" => "Error",
                "error" => $error
            ];
        }
    }

    public function deleteDeviceEndPoint($deviceArn)
    {
        try {
            $this->sns->deleteEndpoint([
                "EndpointArn" => $deviceArn
            ]);
            return [
                "success" => true,
                "message" => "OK"
            ];
        } catch (\Exception $error) {
            return [
                "success" => false,
                "message" => "error"
            ];
        }
    }

    public function subscribeDevicetoTopic($endPointArn)
    {
        try {
            $result = $this->sns->subscribe([
                'Endpoint' => $endPointArn,
                'Protocol' => $this->protocol,
                'TopicArn' => $this->topicARN,
            ]);
            return [
                "success" => true,
                "message" => "OK",
                "result" => $result
            ];
        } catch ( \Exception $error ) {
            return [
                "success" => false,
                "message" => "error",
            ];
        }
    }

    public function sendMessageByTopic($message)
    {   
        try{
            $result = $this->sns->publish([
                'Message' => json_encode($message),
                'MessageStructure' => 'json',
                'TopicArn' => $this->topicARN
            ]);
            return [
                "success" => true,
                "message" => "OK",
                "result" => $result
            ];
        } catch (\Exception $error) {
            return [
                "success" => false,
                "message" => "error",
                "error" => $error
            ];
        }
    }

    public function sendMessageByPlatform($message, $platform)
    {
        $appArn = "";
        if ( $platform == "android" ) {
            $appArn = self::GCM_ARN; 
        } elseif ( $platform == "ios" ) {
            $appArn = self::APNS_ARN;
        } else {
            return [
                "success" => false,
                "message" => "error"
            ];
        }

        $endPointList = [];

        $endPointList = $this->sns->listEndpointsByPlatformApplication([
            'PlatformApplicationArn' => $appArn
        ]);
        
        foreach( $endPointList["Endpoints"] as $endPoint ) {
            $endPointArn = $endPoint['EndpointArn'];
            try {
                $this->sns->publish([
                    'Message' => json_encode($message),
                    'MessageStructure'=>'json',
                    'TargetArn' => $endpointArn
                ]);
                return [
                    "success" => true,
                    "message" => "OK"
                ];
            } catch (\Exception $error) {
                return [
                    "success" => false,
                    "message" => "error"
                ];
            }
        }
    }

    public function deleteSubscription($subscriptionArn)
    {
        try {
            $this->sns->unsubscribe([
                'SubscriptionArn' => $subscriptionArn
            ]);
            return [
                "success" => true,
                "message" => "OK"
            ];
        } catch (\Exception $error) {
            return [
                "success" => false,
                "message" => "error"
            ];
        }
    }

    public function asyncPublish($message, $arn, $type )
    {
        $data = [];
        $data['Message'] = json_encode($message);
        $data['MessageStructure'] = 'json';
        if ( $type == self::PLATFORM_PUBLISH ) {
            $data['TargetArn'] = $arn;
        } else if ( $type == self::TOPIC_PUBLISH ) {
            $data['TopicArn'] = $arn;
        }
        try{
            $this->sns->publish($data);
            return [
                "success" => true,
                "message" => "success"
            ];
        } catch (\Exception $error ) {
            //for debuggin purpose
            // file_put_contents("error.txt", $error);
            return [
                "success" => false,
                "message" => "error"
            ];
        }
    }

}

$dbcred = file_get_contents("server_cred");

$dbcred = explode(":", $dbcred);

// print_r($dbcred);die;

$dbh = new PDO('mysql:host=localhost;dbname=applau8_ooly_db', 'root', 'Key^3)%6NGeW');
$dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$sql = "SELECT `asl`.`start_time`, `asl`.`repeat_day`,".
"utcTime(`ais`.`timezone`, `asl`.`start_time`) as interval_seconds,".
"device_arn, ais.user_id, platform, label ".
"FROM ai_schedule_list as asl ".
"JOIN ai_session as ais ON ais.device_id=asl.device_id AND ais.user_id=asl.user_id AND ais.light_period_start=1 ".
"WHERE (FIND_IN_SET(DATE_FORMAT(UTC_TIMESTAMP(), '%a'), `asl`.`repeat_day`)>0) ".
"GROUP BY asl.schedule_id ".
"HAVING interval_seconds >= 0 AND interval_seconds <= 900";

$stmt = $dbh->prepare($sql);
$result = [];
try{
$stmt->execute();
$result = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (\PDOException $error) {
    //for debugging purpose
    // shell_exec("echo '\n-----------------------------------------' >> dberror.log;date +'%Y-%m-%d %H:%M:%S' >> dberror.log; echo '{$error}' >> dberror.log");
}
$sns = new SNSPush("", "application");

foreach ( $result as $row ) {
    $message = "";
    if ( strtolower($row["platform"]) == "android" ) {
        $message =  [
            "default" => "light_period_start",
            "GCM" => json_encode([
                "data" => [
                    "alert" => "{$row["label"]} - Light Period is about to start",
                    "pushId" => 2,
                    "notificationType" => "light_period"
                ]
            ])
        ];
    } else if ( strtolower($row["platform"]) == "ios" ) {
        $message = [
            "default" => "light_period_start",
            "APNS"=>json_encode([
                "aps"=>[
                    "alert"  => "{$row["label"]} - Light Period is about to start",
                    "sound"=>"default",
                    "notificationType" => "light_period"
                ]
            ])    
        ];
    }
    $response = $sns->asyncPublish($message, $row["device_arn"], $sns::PLATFORM_PUBLISH);
}

