<?php

class Content extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->helper('url');
        $this->load->helper('email');
        $this->load->helper('cookie');
        $this->load->model('Common_model');
        $this->load->library('session');
        $language = $this->session->userdata('language');
        $this->datetime = date('Y-m-d H:i:s');
        $this->load->library('pagination');
        $this->load->database();
        // Load form helper library
        $this->load->helper('form');
        // Load form validation library
        $this->load->library('form_validation');
        if (empty($this->session->userdata['logged_in']) && ($this->session->userdata['logged_in'] == '')) {
            // if(empty($this->session->userId) && ($this->session->userId))
            redirect(base_url() . 'Index/login');
        }
    }

    public function index() {
        $data = array();
        $slug = $this->uri->segment(3);
        if (empty($slug)) {
            $slug = "aboutus";
        }
        $data['edit_content_data'] = $this->Common_model->fetch_data('ai_content', "*", array('where' => array('slug' => $slug)));
        $data['post'] = $this->input->post();
        if (!empty($data['post'])) {
            $title = isset($data['post']['content_title']) ? $data['post']['content_title'] : '';
            $message = isset($data['post']['content_description']) ? $data['post']['content_description'] : '';
            $message_fer = isset($data['post']['content_description_fer']) ? $data['post']['content_description_fer'] : '';
            $slug = isset($data['post']['content_save']) ? $data['post']['content_save'] : "";
            $content_data = array('title' => mysqli_real_escape_string($this->db->conn_id, trim($title)), 'content_eng' => mysqli_real_escape_string($this->db->conn_id, trim($message)),'content_fer' => mysqli_real_escape_string($this->db->conn_id, trim($message_fer)) ,'posted_date' => date('Y-m-d h:i:sa'), 'slug' => $slug);
            $updated_data = array('content_eng' => mysqli_real_escape_string($this->db->conn_id, trim($message)), 'content_fer' => mysqli_real_escape_string($this->db->conn_id, trim($message_fer)),'updated_date' => date('Y-m-d h:i:sa'));
            $last_inserted_id = $this->Common_model->insertupdate('ai_content', $content_data, $updated_data);
            $data['id'] = $last_inserted_id;
            if ($last_inserted_id) {
                $this->session->set_flashdata('message', '<div class="alert alert-success text-center">Content has been saved successfully!</div>');
            } else {
                $this->session->set_flashdata('error_message', '<div class="alert alert-danger text-center">There is some error, Please try again.</div>');
            }
            redirect('Content/index/' . $slug);
        }

        $this->Common_model->load_views_afterlogin('Content/' . $slug, $data);
    }

}
