<?php

require_once APPPATH . "composer/vendor/autoload.php";
require_once APPPATH . "libraries/AwsSNS.php";

class Firmware extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->helper('url');
        $this->load->helper('email');
        $this->load->helper('cookie');
        $this->load->model('Common_model');
        $this->load->model('Firmware_model');
        $this->load->model('User_model');
        $this->load->model('Notification_model');
        $this->load->library('session');
        $language = $this->session->userdata('language');
        $this->datetime = date('Y-m-d H:i:s');
        $this->load->library('pagination');
// Load form helper library
        $this->load->helper('form');
// Load form validation library
        $this->load->library('form_validation');
        if (empty($this->session->userdata['logged_in']) && ($this->session->userdata['logged_in'] == '')) {
// if(empty($this->session->userId) && ($this->session->userId))
            redirect(base_url() . 'Index/login');
        }
    }

    public function index() {
        $data = array();
        $params = array();
        $getrequest = $this->input->get();
        $page = isset($getrequest['page']) ? $getrequest['page'] : 1;
        $pagecount = isset($getrequest['pagecount']) ? $getrequest['pagecount'] : 10;
        $limit = $pagecount;
        $condition = array('where' => array('firmware_status' => 1));
        if (isset($_GET['search']) && $_GET['search'] != '') {
            $params['firmware_version'] = trim($_GET['search']);
            $data['search'] = $_GET['search'] != '' ? $_GET['search'] : "";
            $condition = array('where' => array('firmware_status' => 1), 'like' => array('firmware_version' => trim($_GET['search'])));
        }

        $rowcount = $this->Common_model->totalCount('ai_firmware', $condition);
        $config['use_page_numbers'] = TRUE;
        $config['page_query_string'] = TRUE;
        $config['reuse_query_string'] = TRUE;
        $config['query_string_segment'] = 'page';
        $config['attributes'] = array('class' => 'pagination-container');
        // $config['cur_tag_open'] = '<li><a href="#">';
        // $config['cur_tag_close'] = '</a></li>';
        // $config['num_tag_open'] = '<li><a>';
        // $config['num_tag_open'] = '</a></li>';
        $config['base_url'] = base_url() . 'Firmware/index';
        $config['total_rows'] = !empty($rowcount) ? $rowcount->rows : 0;

        $config["per_page"] = $limit;
        $config["uri_segment"] = 3;
        $this->pagination->initialize($config);
        $where['type'] = isset($_GET['type']) ? $_GET['type'] : "";
        $where['order'] = isset($_GET['order']) ? $_GET['order'] : "";
        if ($where['order'] == "DESC") {
            $data[$where['type']]['nameorder'] = "ASC";
        } else if ($where['order'] == "ASC") {
            $data[$where['type']]['nameorder'] = "DESC";
        } else {
            $data[$where['type']]['nameorder'] = "";
        }
        $params['sort_by'] = $where['type'];
        $params['sort_order'] = $data[$where['type']]['nameorder'];
        if (isset($_GET['action']) && $_GET['action'] == 'sorting') {
            $params['sort_by'] = $_GET['name'];
            $params['sort_order'] = $_GET['sort_order'];
        }
        $firmware = $data['firmware_list'] = $this->Firmware_model->fetch_firmware_data($limit, $offset = ($page - 1) * $limit, $params);
        $data['offset'] = ($page - 1) * $limit;
        if ($rowcount->rows > 10) {
            $data["links"] = $this->pagination->create_links();
        }
        $this->Common_model->load_views_afterlogin('Firmware/index', $data);
    }

    public function add_publish_update() {
        $data = array();
        $data['post'] = $this->input->post();
        if (!empty($data['post'])) {
            define("UPLOAD_DIR", APPPATH . "../public/uploads/firmwareuploads/");
            $version_check = $this->Common_model->fetch_data('ai_firmware', array('MAX(firmware_version) as ver'), array('where' => array('firmware_status' => 1)), true);
            if (!empty($version_check)&&$version_check['ver']>= $data['post']['Firmware_Version']) {
             
                $this->session->set_flashdata('error_message', '<div class="alert alert-danger text-center">Please Select Version greater than '.$version_check['ver'].'</div>');
                redirect(base_url() . 'Firmware/index');    
            }
            if (isset($_FILES['upload_file']) && !empty($_FILES['upload_file'])) {
                if ($_FILES['upload_file']['error'] === UPLOAD_ERR_OK) {
                    $filename = explode(".", $_FILES["upload_file"]['name']);
                    $dot_count = count($filename);
                    $ext = $filename[$dot_count - 1];
                    if ($ext != "signed") {
                        $data['upload_file_error'] = "Only signed files are required";
                    }
                    $name = $data['post']['Firmware_Version'] . "_" . time() . "." . $ext;
                    $success = move_uploaded_file($_FILES["upload_file"]["tmp_name"], UPLOAD_DIR . $name);
                    if (!$success) {
                        $data['upload_file_error'] = 'Image couldnot be saved';
                        chmod(UPLOAD_DIR . $name, 0644);
                    } else {
                        
                    }
                }
            }
                $firmware_data = array('firmware_version' => $data['post']['Firmware_Version'], 'updation_date' => date('Y-m-d', strtotime(str_replace('/', '-', $data['post']['Updation_Date']))), 'firmware_file' => $name, 'firmware_info'=>$data['post']['Firmware_info'],'created_date_version' => date('Y-m-d h:i:sa'), 'is_published' => "2", 'status' => "1");

                $last_inserted_id = $this->Common_model->insert('ai_firmware', $firmware_data);
                if (isset($last_inserted_id)&&!empty($last_inserted_id)) {
                    $this->session->set_flashdata('message', '<div class="alert alert-success text-center"> Firmware is Uploaded </div>');

                    $this->session->set_flashdata('admin_notification_message', 'Notification has been saved');
                    $this->publishNotifications($last_inserted_id);
                    redirect('Firmware/index');
                    // $this->publish_notification($last_inserted_id, $firmware_data);
                } else {
                    $this->session->set_flashdata('error_message', '<div class="alert alert-danger text-center">There is some error , Please try again later</div>');
                    $this->session->set_userdata(array('last_inserted_id' => $last_inserted_id));
                }
                $data["modal"] = "true";
            }
            $this->Common_model->load_views_afterlogin('Firmware/index', $data);
        
    }

    private function publishNotifications($firmwareId)
    {
        $firmwareData = $this->Firmware_model->fetchFirmware($firmwareId);
        $message = [
            "default" => "firmware_update",
            "GCM" => json_encode([
                "data" => [
                    "alert" => "Ooly Firmware Update",
                    "pushId" => 1,
                    'url' => "http://" . $_SERVER['SERVER_NAME'] . '/admin/public/uploads/firmwareuploads/' . $firmwareData["firmware_file"],
                    "version" => $firmwareData["firmware_version"],
                    "notificationType" => "firmware_update",
                    "tt" => time()
                ]
            ]),
            "APNS"=>json_encode([
                "aps"=>[
                    "alert"  => "Ooly Firmware update",
                    'notificationType' => "firmware_update",
                    'version' => $firmwareData["firmware_version"],
                    'url' => "http://" . $_SERVER['SERVER_NAME'] . '/admin/public/uploads/firmwareuploads/' . $firmwareData["firmware_file"],
                    "sound"=>"default"
                ]
            ])         
        ];

        $sns = new AwsSNS("arn:aws:sns:us-west-2:634381625056:firmware_update", "application");
        $response = $sns->sendMessageByTopic($message);

    }

    public function publish_notification($last_inserted_id = "", $firmware_data = "") {
        if (isset($_GET['firmware_id']) && isset($_GET['firmware_version'])) {
            $last_inserted_id = base64_decode($_GET['firmware_id']);
            $firmware_version = $_GET['firmware_version'];
            $firmware_file = $_GET['firmware_file'];
        }
        $get_all_users = $this->User_model->get_all_users($last_inserted_id);
        $firmware_version = isset($firmware_data['firmware_version']) ? $firmware_data['firmware_version'] : $firmware_version;
        $firmware_file = isset($firmware_data['firmware_file']) ? $firmware_data['firmware_file'] : $_GET['firmware_file'];
        $title = "Firmware Version " . $firmware_version;
        $message = "Firmware Version " . $firmware_version . " is available. Please Update your Firmware";
        $notification_data = array('title' => $title, 'message' => $message, 'posted_date' => date('Y-m-d h:i:sa'), 'type' => 'firmware_update');
        $last_inserted_id = $this->Common_model->insert('ai_notification', $notification_data);

        $device_tokens = $this->User_model->fetch_session_data(implode(",", $get_all_users), "firmware_update");
        if(!empty($device_tokens)):
        foreach ($device_tokens as $key => $value) {
            if ($value['platform'] == "ANDROID") {
                $device_token['ANDROID'] = array_map(
                        function ($substr) {
                    return explode('|', $substr);
                }, explode(',', $value['tokens'])
                );
                $device_token_android_chunk = array_chunk($device_token['ANDROID'], 3);
                $payload = array(
                    'alert' => $message,
                    'notificationType' => "firmware_update",
                    'version' => $firmware_version,
                    'tt' => time(),
                    'url' => "http://" . $_SERVER['SERVER_NAME'] . '/admin/public/uploads/firmwareuploads/' . $firmware_file,
                    'pushId' => 1
                );
                foreach ($device_token_android_chunk as $index => $data) {
                    $data = json_encode($data);
                    $notification_log_data = array('notification_id' => $last_inserted_id, 'users' => $data, 'notification_status' => 2, 'platform' => 'ANDROID', 'payload' => json_encode($payload), 'posted_date' => date('Y-m-d h:i:sa'));
                    $last_inserted_notification_id = $this->Common_model->insert('ai_notification_log', $notification_log_data);
                }
            }
            if ($value['platform'] == "Ios") {
                // $device_token['Ios'] = explode(",", $device_tokens[$key]['tokens']);
                $device_token['Ios'] = array_map(
                        function ($substr) {
                    return explode('|', $substr);
                }, explode(',', $value['tokens']));
                $device_token_ios_chunk = array_chunk($device_token['Ios'], 3);
                $payload_ios = array('aps' => array(
                        'alert' => $message,
                        'notificationType' => "firmware_update",
                        'version' => $firmware_version,
                        'url' => "http://" . $_SERVER['SERVER_NAME'] . '/admin/public/uploads/firmwareuploads/' . $firmware_file
                    )
                );
                foreach ($device_token_ios_chunk as $index => $data) {
                    $data = json_encode($data);
                    $notification_log_data = array('notification_id' => $last_inserted_id, 'users' => $data, 'notification_status' => 2, 'platform' => 'Ios', 'payload' => json_encode($payload_ios), 'posted_date' => date('Y-m-d h:i:sa'));
                    $last_inserted_notification_id = $this->Common_model->insert('ai_notification_log', $notification_log_data);
                }
            }
        }
        endif;
        $this->session->set_flashdata('message', '<div class="alert alert-success text-center">Firmware Notification has been sent!</div>');
           
        redirect("Firmware/index");
    }

}
