<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Index extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->helper('url');
        $this->load->helper('email');
        $this->load->helper('cookie');
        $this->load->helper('form');
        $this->load->model('Common_model');
        $this->load->model('Admin_model');
        //$this->load->language('common');
        $this->load->library('session');
        $this->datetime = date('Y-m-d H:i:s');
        $this->load->library('form_validation');
        error_reporting(E_ALL);
    }

    /**
     * Index function
     * @access	public
     */
    public function index() {
        $data = array();
        if ($this->session->userdata('logged_in') == FALSE) {
            redirect(base_url() . 'Index/login');
        } else {
            redirect(base_url() . 'User/index');
        }
    }

    /**
     * Function name: authAdLogin
     * Description-Session checking, user is loggedin or not.
     */
    public function authAdLogin() {
        if ($this->session->userdata('logged_in') == FALSE) {
            redirect('Index/login');
        }
    }

    /* Function name: login
     * Description-login funtion, admin will login if he is registered.
     * Date: 6/04/2017

     */

    public function login() {
        if ($this->input->post()) {
            $this->form_validation->set_rules('admin_email', 'Email', 'trim|required|valid_email');
            $this->form_validation->set_rules('admin_password', 'Password', 'trim|required|min_length[6]|max_length[26]');

            if ($this->form_validation->run() == FALSE) {

                $data = array();
                // redirect(SITE_URL . '/admin/login');
                //$this->Common_model->load_views('Index/index', $data);
            } else {
                $adminname = $this->input->post("admin_email");
                $adminpassword = $this->input->post("admin_password");
                $admin_detail = $this->Admin_model->adminlogin($adminname, $adminpassword);
                if ($admin_detail) {
                    $newdata = array(
                        "admin_id" => $admin_detail['admin_id'],
                        "admin_first_name" => $admin_detail['first_name'],
                        //"admin_last_name" => $admin_detail['last_name'],
                        "admin_phone" => $admin_detail['contact_no'],
                        "admin_email" => $admin_detail['email'],
                        "admin_image" => $admin_detail['image'],
                        'logged_in' => TRUE 
                    );

                    $session_data = $this->session->set_userdata($newdata); // Storing session;
                    redirect(base_url() . 'User/index', 'refresh');
                } else {
                    $this->session->set_flashdata('message', 'Invalid Credentials.');
                    redirect('Index/login');
                }
            }
        }
        $data = array();
        //redirect('Index/');
        $this->Common_model->load_views('Index/index', $data);
    }

    /* Function name: logout
     * Description-logout funtion, admin will logged out if he is logged in.
     * Date: 6/04/2017

     */

    public function logout() {
        // $this->authAdLogin();
        $this->session->sess_destroy();
        redirect('index');
    }

    public function forgotpassword() {
      
        $data = $this->input->post();
    
        $value = array();
        if (!empty($data)) {
            $email = isset($data['forgot_password_email']) ? $data['forgot_password_email'] : '';
            if (!empty($email)) {
               
//                $adminData = $this->Common_model->fetch_data('ai_admin', '', array(), true);
//                echo"<pre>";print_r($adminData); die;
                $adminData = $this->Common_model->fetch_data('ai_admin', '', array('where' => array('email' => $email)), true);
               
                if (!empty($adminData)) {
                    $subject = 'Reset Password Request';
                    $message = ' ';
                    $postDataArr['name'] = $adminData['first_name'];

                    $postDataArr['id'] = $adminData['admin_id'];
                    $param = $postDataArr;

                    $a = $this->Common_model->sendmail($adminData['email'], $subject, $message, true, $param, 'forgotadmin.php');
                    $this->session->set_flashdata('reset_password_message', 'Link for reset password has been successfully send to your email');
                    redirect('Index/login');
                } else {

                    $value['message'] = "Email address is not registered with us.";
                }
            } else {

                $value['message'] = "Please enter a valid email.";
            }
        }
        //$value = "";

        $this->Common_model->load_views('Index/forgotpassword', $value);
    }

    /**
     * Function name: reset_password
     * Description-Decoding admin id from url and updating
     * new password corrosponding to admin_id if new_password and con_password matches.
     */
    public function reset_password() {
        if (isset($_GET['id']))
            $id = base64_decode($_GET['id']);
        //echo $id;die;
        // $data = $this->input->post();
        $value = array();
        $new_password = $this->input->post('reset_password');
        $con_password = $this->input->post('confirm_reset_password');
        $post_id = base64_decode($this->input->post('admin_id'));
        if (!empty($new_password) && !empty($con_password)) {
            if ($new_password != $con_password) {
                $this->session->set_flashdata('reset_message', ' Password does not match.');
                redirect(base_url() . 'Index/reset_password?id=' . base64_encode($post_id));
            } else {
                $updateArr['password'] = md5($new_password);
                $a = $this->Common_model->update_single('ai_admin', $updateArr, array('where' => array('admin_id' => $post_id)));

                $this->session->set_flashdata('reset_message_success', ' Password reset successfully.');
                redirect(base_url() . 'Index/index');
            }
        } else {
            $value['message'] = 'Please fill all required fields.';
        }
        //$value = array();
        $this->Common_model->load_views('Index/resetpassword', $value);
    }

    /**
     * Function name: change_password
     * Description-User list.
     * Date: 02/02/2017
     * @author 
     */
    function changepassword() {
        $this->authAdLogin();
        $uid = $this->session->userdata('admin_id');
        $data = $this->Common_model->fetch_data('ai_admin', '', array('where' => array('admin_id' => $uid)), true);
        if ($this->input->post()) {
            extract($this->input->post());
            // echo SITE_URL;die;
            if ($data['password'] != md5($current_password)) {
                $this->session->set_flashdata('message', 'Current password is not correct.');
                redirect(base_url() . 'Index/changepassword');
            } else if ($new_password != $confirm_password) {
                $this->session->set_flashdata('message', 'Confirm password does not match.');
                redirect(base_url() . 'Index/changepassword');
            } else if ($new_password == $confirm_password) {
                $updateData = array(
                    'password' => md5($new_password)
                );
                $this->session->set_flashdata('message', 'Your password has been changed.');
                $this->Common_model->update_single('ai_admin', $updateData, array('where' => array('admin_id' => $uid)));
                redirect(base_url() . 'User/index');
            }
        }
        $this->Common_model->load_views_afterlogin('Index/changepassword');
    }

    function editprofile() {
        $this->authAdLogin();
        $uid = $this->session->userdata('admin_id');
        $data['admin_info'] = $this->Common_model->fetch_data('ai_admin', '', array('where' => array('admin_id' => $uid)), true);
        if ($this->input->post()) {
            extract($_POST);
            define("UPLOAD_DIR", $_SERVER['DOCUMENT_ROOT'] . "/dev/v1/uploads/");
            if (isset($_FILES['profile_image']) && !empty($_FILES['profile_image'])) {

                if ($_FILES['profile_image']['error'] === UPLOAD_ERR_OK) {
                    $format = array("IMAGETYPE_JPG", "3", "IMAGETYPE_JPEG", "2", "1", "IMAGETYPE_PNG");
                    if (!in_array(exif_imagetype($_FILES['profile_image']['tmp_name']), $format)) {
                       $data ['error_message']= 'Only Jpg, png file required';
                
              //  $this->load->view('index/login', $data);
                    }
                    $filename = explode(".", $_FILES["profile_image"]['name']);
                    $dot_count = count($filename);
                    $ext = $filename[$dot_count - 1];
                    $name = time() . "." . $ext;
                    $success = move_uploaded_file($_FILES["profile_image"]["tmp_name"], UPLOAD_DIR . $name);
                    if (!$success) {
                          $this->session->set_flashdata('edit_image_failure', 'Image couldnot be saved');
                    redirect(base_url() . 'Index/editprofile');
                    }

                    // set proper permissions on the new file
                    chmod(UPLOAD_DIR . $name, 0644);
                } else {
                    // throw new Uploadexception($_FILES['profile_image']['error']);
                }
                $user = [ "email" => $admin_email, "contact_no" => $admin_contact_number];
                if (isset($name)) {
                    $user["image"] = $name;
                }
                if(!isset($data['error_message'])){
                $a = $this->db->update('ai_admin', $user, array('admin_id' => $uid));
            }
                if (isset($a)&&!empty($a)) {
                    $this->session->set_flashdata('edit_message_success', ' Profile  is updated.');
                    redirect(base_url() . 'Index/editprofile');
                }
            }
        }
        $this->Common_model->load_views_afterlogin('Index/editprofile', $data);
    }

}
