<?php

require_once APPPATH . "composer/vendor/autoload.php";
require_once APPPATH . "libraries/AwsSNS.php";

class Notification extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->helper('url');
        $this->load->helper('email');
        $this->load->helper('cookie');
        $this->load->model('Common_model');
        $this->load->model('Notification_model');
        $this->load->model('User_model');
        $this->load->library('session');
        $language = $this->session->userdata('language');
        $this->datetime = date('Y-m-d H:i:s');
        $this->load->library('pagination');
        // Load form helper library
        $this->load->helper('form');
        // Load form validation library
        $this->load->library('form_validation');
        if (empty($this->session->userdata['logged_in']) && ($this->session->userdata['logged_in'] == '')) {
            // if(empty($this->session->userId) && ($this->session->userId))
            redirect(base_url() . 'Index/login');
        }
    }

    public function index() {
        $data = array();
        $params = array();
        $getrequest = $this->input->get();
        $page = isset($getrequest['page']) ? $getrequest['page'] : 1;
        $pagecount = isset($getrequest['pagecount']) ? $getrequest['pagecount'] : 10;
        $limit = $pagecount;
        $condition = array('where' => array('notification_status' => 1));
        $rowcount = $this->Common_model->totalCount('ai_notification', $condition);
        $config['use_page_numbers'] = TRUE;
        $config['page_query_string'] = TRUE;
        $config['reuse_query_string'] = TRUE;
        $config['query_string_segment'] = 'page';
        $config['attributes'] = array('class' => 'pagination-container');
        // $config['cur_tag_open'] = '<li><a href="#">';
        // $config['cur_tag_close'] = '</a></li>';
        // $config['num_tag_open'] = '<li><a>';
        // $config['num_tag_open'] = '</a></li>';
        $config['base_url'] = base_url() . 'Notification/index';
        $config['total_rows'] = !empty($rowcount) ? $rowcount->rows : 0;
        $config["per_page"] = $limit;
        $config["uri_segment"] = 3;
        $this->pagination->initialize($config);
        if (isset($_GET['search']) && $_GET['search'] != '') {
            $params['title'] = trim($_GET['search']);
            $data['search'] = $_GET['search'] != '' ? $_GET['search'] : "";
        }
        $where['type'] = isset($_GET['type']) ? $_GET['type'] : "";
        $where['order'] = isset($_GET['order']) ? $_GET['order'] : "";

        if ($where['order'] == "DESC") {
            $data[$where['type']]['nameorder'] = "ASC";
        } else if ($where['order'] == "ASC") {
            $data[$where['type']]['nameorder'] = "DESC";
        } else {
            $data[$where['type']]['nameorder'] = "";
        }
        $params['sort_by'] = $where['type'];
        $params['sort_order'] = $data[$where['type']]['nameorder'];
//        if (isset($getrequest['action']) && $getrequest['action'] == 'sorting') {
//            $params['sort_by'] = $getrequest['name'];
//            $params['sort_order'] = $getrequest['sort_order'];
//        }
        $notification = $data['notification_list'] = $this->Notification_model->fetch_notification_data($limit, $offset = ($page - 1) * $limit, $params);
        $data['offset'] = ($page - 1) * $limit;
        $data["links"] = $this->pagination->create_links();
        $this->Common_model->load_views_afterlogin('Notification/index', $data);
        $post = $this->input->post();
        extract($this->input->post());
        if (isset($csv)) {
            $this->actionExportUserData($user);
        }
    }

    /**
     * For Insert Notification into Notification Table
     * 
     */
    public function createnotification() {
        $data = array();
        $getdata = $this->input->get();
        if (isset($getdata['notification_id']) && !empty($getdata['notification_id'])) {
            $notification_id = base64_decode($getdata['notification_id']);
            $data['edit_notification_data'] = $this->Common_model->fetch_data('ai_notification', "*", array('where' => array('notification_id' => $notification_id)));
        }
        $data['post'] = $this->input->post();
        if (!empty($data['post'])) {
            $title = isset($data['post']['pg_content_title']) ? $data['post']['pg_content_title'] : '';
            $message = isset($data['post']['pg_content_message']) ? $data['post']['pg_content_message'] : '';
            $notification_id = isset($data['post']['notification_id']) ? $data['post']['notification_id'] : "";
            if (empty($notification_id)) {
                $notification_data = array('title' => $data['post']['pg_content_title'], 'message' => $data['post']['pg_content_message'], 'type' => $data['post']['notification_type'], 'posted_date' => date('Y-m-d h:i:sa'));
                $last_inserted_id = $this->Common_model->insert('ai_notification', $notification_data);
            } else {
                $notification_data = array('title' => $data['post']['pg_content_title'], 'message' => $data['post']['pg_content_message'], 'type' => $data['post']['notification_type'], 'updated_date' => date('Y-m-d h:i:sa'));
                $update_status = $this->Common_model->update_single('ai_notification', $notification_data, array('where' => array('notification_id' => $notification_id)));
            }

            if ($data['post']['notification_send_save'] == 'notification_save') {
                $this->session->set_flashdata('message', '<div class="alert alert-success text-center">Notification has been saved.!</div>');
              
                redirect('Notification/index');
            } else {
                $this->session->set_userdata(array('last_inserted_id' => $last_inserted_id));
                $this->session->set_flashdata('error_message', '<div class="alert alert-danger text-center">There is some error Please try again later.</div>');
                redirect('Notification/sendnotification');
            }
        }
        $this->Common_model->load_views_afterlogin('Notification/createnotificcation_one', $data);
    }

    /**
     * For Sending Push Notification to users
     * @param: last InsertId
     */
    public function sendnotification() {
        $last_insert_id = isset($this->session->userdata['last_inserted_id']) ? $this->session->userdata['last_inserted_id'] : "";
        if (!isset($this->session->userdata['notification_id']) || empty($this->session->userdata['notification_id'])) {
            $notification_id = isset($_GET['notification_id']) ? base64_decode($_GET['notification_id']) : $last_insert_id;
            $this->session->set_userdata(array('notification_id' => $notification_id));
            $last_inserted_id = $this->session->userdata['notification_id'];
        }

        $data = array();
        $params = array();
        $getrequest = $this->input->get();
        $page = isset($getrequest['page']) ? $getrequest['page'] : 1;
        $pagecount = isset($getrequest['pagecount']) ? $getrequest['pagecount'] : 10;
        $limit = $pagecount;
        $condition = array('where' => array('user_status' => 1));
        $rowcount = $this->Common_model->totalCount('ai_user', $condition);
        $config['use_page_numbers'] = TRUE;
        $config['page_query_string'] = TRUE;
        $config['reuse_query_string'] = TRUE;
        $config['query_string_segment'] = 'page';
        $config['attributes'] = array('class' => 'pagination-container');
        $config['base_url'] = base_url() . 'Notification/sendnotification';
        $config['total_rows'] = !empty($rowcount) ? $rowcount->rows : 0;
        $config["per_page"] = $limit;
        $config["uri_segment"] = 3;
        $this->pagination->initialize($config);
        if (isset($getrequest['search']) && $getrequest['search'] != '') {
           
          $params['search'] = trim($getrequest['search']);
          
            $data['search'] = $getrequest['search'] != '' ? $getrequest['search'] : "";
        }
        $where['type'] = isset($getrequest['type']) ? $getrequest['type'] : "";
        $where['order'] = isset($getrequest['order']) ? $getrequest['order'] : "";
        if ($where['order'] == "DESC") {
            $data[$where['type']]['nameorder'] = "ASC";
        } else if ($where['order'] == "ASC") {
            $data[$where['type']]['nameorder'] = "DESC";
        } else {
            $data[$where['type']]['nameorder'] = "";
        }
        $params['sort_by'] = $where['type'];
        $params['sort_order'] = $data[$where['type']]['nameorder'];
        $user = $data['user_list'] = $this->User_model->fetch_user_list($limit, $offset = ($page - 1) * $limit, $params);
        $data["links"] = $this->pagination->create_links();

        $this->Common_model->load_views_afterlogin('Notification/createnotification_two', $data);
        if (isset($_POST['send_notification']) && !empty($_POST['send_notification'])) {
            if (($_POST['send_notification']) == "all_users") {
                $selected_users = "All";
            } else {
                if (isset($_POST['selected_users']) && !empty($_POST['selected_users'])) {
                    $selected_users = $_POST['selected_users'];
                } else {
                    $this->session->set_flashdata('message', 'Please select users to send notification');
                    redirect('Notification/sendnotification');
                }
            }

            $notification_data = $this->Common_model->fetch_data('ai_notification', "*", array('where' => array('notification_id' => $this->session->userdata['notification_id'])));
            if(!empty($notification_data)):
                if ( $_POST['send_notification'] == "all_users" ) {
                    $this->publishNotifications($notification_data);
                }
            // $device_tokens = $this->User_model->fetch_session_data($selected_users, $notification_data[0]['type']);
            endif;
            if(isset($device_tokens)&&!empty($device_tokens)):
            // foreach ($device_tokens as $key => $value) {
            //     if ($value['platform'] == "ANDROID") {
            //         $device_token['ANDROID'] = array_map(
            //                 function ($substr) {
            //             return explode('|', $substr);
            //         }, explode(',', $value['tokens'])
            //         );
            //         $device_token_android_chunk = array_chunk($device_token['ANDROID'], 100);
            //         $payload = array(
            //             'alert' => $notification_data[0]['message'],
            //             'notificationType' => $notification_data[0]['type'],
            //             'tt' => time(),
            //             'pushId' => 1
            //         );
            //         foreach ($device_token_android_chunk as $index => $data) {
            //             $data = json_encode($data);
            //             $notification_log_data = array('notification_id' => $this->session->userdata['notification_id'], 'users' => $data, 'notification_status' => 2, 'platform' => 'ANDROID', 'payload' => json_encode($payload), 'posted_date' => date('Y-m-d h:i:sa'));
            //             $last_inserted_notification_id = $this->Common_model->insert('ai_notification_log', $notification_log_data);
            //         }
            //     }
            //     if ($value['platform'] == "Ios") {
            //         // $device_token['Ios'] = explode(",", $device_tokens[$key]['tokens']);
            //         $device_token['Ios'] = array_map(
            //                 function ($substr) {
            //             return explode('|', $substr);
            //         }, explode(',', $value['tokens'])
            //         );
            //         $device_token_ios_chunk = array_chunk($device_token['Ios'], 100);
            //         $payload_ios = array('aps' => array(
            //                 'alert' => $notification_data[0]['message'],
            //                 'notificationType' => $notification_data[0]['type'],
            //                 'badge' => 1,
            //                 'tt' => time(),
            //                 'sound' => 'default')
            //         );
            //         foreach ($device_token_ios_chunk as $index => $data) {
            //             $data = json_encode($data);
            //             $notification_log_data = array('notification_id' => $this->session->userdata['notification_id'], 'users' => $data, 'notification_status' => 2, 'platform' => 'Ios', 'payload' => json_encode($payload_ios), 'posted_date' => date('Y-m-d h:i:sa'));
            //             $last_inserted_notification_id = $this->Common_model->insert('ai_notification_log', $notification_log_data);
            //         }
            //     }
            // }
            endif;
            //$notification_log_data = array('notification_id' => $this->session->userdata['notification_id'], 'users' => $selected_user, 'notification_status' => 2, 'posted_date' => date('Y-m-d h:i:sa'));
            //last_inserted_notification_id = $this->Common_model->insert('ai_notification_log', $notification_log_data);
             $this->session->set_flashdata('message', '<div class="alert alert-success text-center">Notification has been sent.!</div>');
            
            $this->session->unset_userdata('notification_id');
            redirect('Notification/index');
        }
    }

    /**
     * Chrone method for sending notification to users
     * 
     */
    public function send() {
        $conditon = array();
        $condition['sort_by'] = "posted_date";
        $condition['sort_order'] = "ASC";
        $condition['notification_status'] = 2;
        $notification_log = $this->Notification_model->fetch_notification_log($condition);
        if (isset($notification_log) && !empty($notification_log)) {

            $array['text'] = "fdgfdg";
            $this->Common_model->insert("o_log", $array);
            if ($notification_log[0]['platform'] == 'ANDROID') {
                $userdata = json_decode($notification_log[0]['users']);
                if(!empty($userdata)):
                $device_token['ANDROID'] = array_map(
                        function ($subarry) {
                    return array_splice($subarry, 0, 1);
                }, $userdata
                );
                $device_token['ANDROID'] = array_map('current', $device_token['ANDROID']);
                $this->Notification_model->andriodPush($device_token['ANDROID'], $notification_log[0]['payload']);
                $update_status = $this->Common_model->update_single('ai_notification_log', array('notification_status' => 1), array('where' => array('log_id' => $notification_log[0]['log_id'])));
                endif;
            }
            if ($notification_log[0]['platform'] == 'Ios') {
                $userdata = json_decode($notification_log[0]['users']);
                if($userdata):
                $device_token['Ios'] = array_map(
                        function ($subarry) {
                    return array_splice($subarry, 0, 1);
                }, $userdata
                );
                $device_token['Ios'] = array_map('current', $device_token['Ios']);
                $this->Notification_model->sendPushMessage($device_token['Ios'], $notification_log[0]['payload']);
                $update_status = $this->Common_model->update_single('ai_notification_log', array('notification_status' => 1), array('where' => array('log_id' => $notification_log[0]['log_id'])));
                endif;
            }
        }
    }

    private function publishNotifications($message)
    {
        $message = [
            "default" => "firmware_update",
            "GCM" => json_encode([
                "data" => [
                    'alert' => $message[0]['message'],
                    'notificationType' => $message[0]['type'],
                    "pushId" => 1,
                    "tt" => time()
                ]
            ]),
            "APNS"=>json_encode([
                "aps"=>[
                    'alert' => $message[0]['message'],
                    'notificationType' => $message[0]['type'],
                    "sound"=>"default"
                ]
            ])         
        ];

        $sns = new AwsSNS("arn:aws:sns:us-west-2:634381625056:application_update", "application");
        $response = $sns->sendMessageByTopic($message);

    }

}
