<?php

class User extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->helper('url');
        $this->load->helper('email');
        $this->load->helper('cookie');
        $this->load->model('Common_model');
        $this->load->model('User_model');
        $this->load->library('session');
        $language = $this->session->userdata('language');
        $this->datetime = date('Y-m-d H:i:s');
        $this->load->library('pagination');
        // Load form helper library
        $this->load->helper('form');
        // Load form validation library
        $this->load->library('form_validation');
        if (empty($this->session->userdata['logged_in']) && ($this->session->userdata['logged_in'] == '')) {
            // if(empty($this->session->userId) && ($this->session->userId))
            redirect(base_url() . 'Index/login');
        }
    }

    public function index() {
        $data = array();
        $params = array();
        $getrequest = $this->input->get();
       $page = isset($getrequest['page']) ? $getrequest['page'] : 1;
        $pagecount = isset($getrequest['pagecount']) ? $getrequest['pagecount'] : 10;
        $limit = $pagecount;
         $condition = array('where' => array('user_status' => 1));
        if (isset($getrequest['search']) && $getrequest['search'] != '') {
            $params['search'] = trim($getrequest['search']);
          
            $data['search'] = $getrequest['search'] != '' ? $getrequest['search'] : "";
                   $condition = array('where' => array('user_status' => 1),'like'=> array('first_name'=>trim($_GET['search']),'email'=>trim($_GET['search'])));

        }
       
        $rowcount = $this->Common_model->totalCount('ai_user',$condition);
      
        
        $config['use_page_numbers'] = TRUE;
        $config['page_query_string'] = TRUE;
        $config['reuse_query_string'] = TRUE;
        $config['query_string_segment'] = 'page';
        $config['attributes'] = array('class' => 'pagination-container');
//        $config['cur_tag_open'] = '<li><a href="#">';
//        $config['cur_tag_close'] = '</a></li>';
//        $config['num_tag_open'] = '<li><a>';
//        $config['num_tag_open'] = '</a></li>';
        $config['base_url'] = base_url() . 'User/index';
        $config['total_rows'] = !empty($rowcount) ? $rowcount->rows : 0;

        $config["per_page"] = $limit;
        $config["uri_segment"] = 3;
        $this->pagination->initialize($config);
        // if (isset($getrequest['search']) && $getrequest['search'] != '') {
        //     $params['first_name'] = trim($getrequest['search']);
        //     $data['search'] = $getrequest['search'] != '' ? $getrequest['search'] : "";
        // }
        $where['type'] = isset($getrequest['type']) ? $getrequest['type'] : "";
        $where['order'] = isset($getrequest['order']) ? $getrequest['order'] : "";
        if ($where['order'] == "DESC") {
            $data[$where['type']]['nameorder'] = "ASC";
        } else if ($where['order'] == "ASC") {
            $data[$where['type']]['nameorder'] = "DESC";
        } else {
            $data[$where['type']]['nameorder'] = "";
        }
        $params['sort_by'] = $where['type'];
        $params['sort_order'] = $data[$where['type']]['nameorder'];
        $user = $this->User_model->fetch_user_list("","", $params);
        $data['user_list'] = $this->User_model->fetch_user_list($limit, $offset = ($page - 1) * $limit, $params);
        $data['offset'] = ($page-1)*$limit;
        if($rowcount->rows >10){
        $data["links"] = $this->pagination->create_links();
    }
//        print_r($data["links"]);
//        die;
        $this->Common_model->load_views_afterlogin('User/index', $data);
        $post = $this->input->post();
        extract($this->input->post());
        if (isset($csv)) {
            $this->actionExportUserData($user);
        }
    }

    public function user_details() {
        $user_id = base64_decode($_GET['userid']);
        $condition = array('user_id' => $user_id);
        $data['usersessionData'] = $this->User_model->fetch_user_detail($condition);
        $data['userData'] = $this->Common_model->fetch_data('ai_user', "*", array('where' => array('user_id' => $user_id)), true);
        $oolydata = $this->User_model->ooly_data($condition);
        $data['oolyData'] = isset($oolydata)?$oolydata:"";
       
        $this->Common_model->load_views_afterlogin('User/user-profile', $data);
    }
    public function schedules_detail(){
         $data=array();
        $ooly_id = $_GET['ooly_id'];
        $data['scheduleData']=$this->Common_model->fetch_data('ai_schedule_list',"*",array('where'=>array('ooly_id'=>$ooly_id)),false,10);
          $this->Common_model->load_views_afterlogin('User/schedules_detail', $data);
    }

    public function actionExportUserData($result) {

        $fileName = 'Userlist_' . date('d-m-Y-g-i-h') . '.xls';
        // The function header by sending raw excel
        header("Content-type: application/vnd-ms-excel");
        // Defines the name of the export file
        header("Content-Disposition: attachment; filename=" . $fileName);
        $format = '<table border="1">'
                . '<tr>'
                . '<th width="25%">S.no</th>'
                . '<th>Name</th>'
                . '<th>Email</th>'
                . '<th>Joining Date</th>'
                . '<th>Address</th>'
                . '<th>Device Id</th>'
                . '<th>Device Token</th>'
                . '<th> Device  Platform  </th>'
                . '</tr>';

        $coun = 1;
        foreach ($result AS $res) {
            if ($res['user_status'] == 1):

                $date = date_create($res['registered_date']);
                $Date = date_format($date, 'd/m/Y');
                $Time = date_format($date, 'g:i A');
                $fld_1 = $coun;
                $fld_2 = (isset($res['first_name']) && ($res['first_name'] != '')) ? $res['first_name'] : '';
                $fld_3 = (isset($res['email']) && ($res['email'] != '')) ? $res['email'] : '';
                $fld_4 = (isset($res['registered_date']) && ($res['registered_date'] != '')) ? $res['registered_date'] : '';
                $fld_5 = (isset($res['address']) && ($res['address'] != '')) ? $res['address'] : '';
                $fld_6 =  (isset($res['device_id']) && ($res['device_id'] != ''))?$res['device_id']:"";
                $fld_7 =  (isset($res['device_token']) && ($res['device_token'] != ''))?$res['device_token']:"";
                $fld_8 =  (isset($res['platform']) && ($res['platform'] != ''))?$res['platform']:"";
                $format .= '<tr>
                        <td>' . $fld_1 . '</td>
                        <td>' . $fld_2 . '</td>
                        <td>' . $fld_3 . '</td>
                        <td>' . $fld_4 . '</td>
                        <td>' . $fld_5 . '</td>
                        <td>' .$fld_6.   '</td>
                        <td>' .$fld_7 .  '</td>
                        <td>' .$fld_8 .  '</td>
                      </tr>';
                $coun++;
            endif;
        }

        echo $format;
        die;
    }

}