<?php

require_once APPPATH . "composer/vendor/autoload.php";

use Aws\Sns\SnsClient;

class AwsSNS {

    const GCM_ARN = "arn:aws:sns:us-west-2:634381625056:app/GCM/Ooly";
    const APNS_ARN = "arn:aws:sns:us-west-2:634381625056:app/APNS/Ooly";
    const REGION = "us-west-2";

    private $topicARN;
    private $sns;
    private $protocol;

    public function __construct($topicARN="", $protocol="")
    {
        $this->topicARN = $topicARN;
        $this->protocol = $protocol;
        $this->sns = SnsClient::factory(array(
            'credentials' => array(
                'key'    => awsAccessKey,
                'secret' => awsSecretKey,
            ),
            'region' => self::REGION,
            'version'=> 'latest'
        ));
    }

    public function addDeviceEndPoint($deviceToken, $deviceType,$userData="")
    {
        if ( $deviceType == "android" ) {
            $platformApplicationArn = self::GCM_ARN;
        } elseif ( $deviceType == "ios" ) {
            $platformApplicationArn = self::APNS_ARN;
        } else {
            return false;
        }

        try {
            $result = $this->sns->createPlatformEndpoint(array(
                'PlatformApplicationArn' => $platformApplicationArn,
                'CustomUserData'=>$userData,
                'Token' => $deviceToken,
            ));
            return [
                "success" => true,
                "message" => "OK",
                "result" => $result
            ];
        } catch (\Exception $error) {
            return [
                "success" => false,
                "message" => "Error"
            ];
        }
    }

    public function deleteDeviceEndPoint($deviceArn)
    {
        try {
            $this->sns->deleteEndpoint([
                "EndpointArn" => $deviceArn
            ]);
            return [
                "success" => true,
                "message" => "OK"
            ];
        } catch (\Exception $error) {
            return [
                "success" => false,
                "message" => "error"
            ];
        }
    }

    public function subscribeDevicetoTopic($endPointArn)
    {
        try {
            $result = $this->sns->subscribe([
                'Endpoint' => $endPointArn,
                'Protocol' => $this->protocol,
                'TopicArn' => $this->topicARN,
            ]);
            return [
                "success" => true,
                "message" => "OK",
                "result" => $result
            ];
        } catch ( \Exception $error ) {
            return [
                "success" => false,
                "message" => "error",
            ];
        }
    }

    public function sendMessageByTopic($message)
    {   
        try{
            $result = $this->sns->publish([
                'Message' => json_encode($message),
                'MessageStructure' => 'json',
                'TopicArn' => $this->topicARN
            ]);
            return [
                "success" => true,
                "message" => "OK",
                "result" => $result
            ];
        } catch (\Exception $error) {
            return [
                "success" => false,
                "message" => "error",
                "error" => $error
            ];
        }
    }

    public function sendMessageByPlatform($message, $platform)
    {
        $appArn = "";
        if ( $platform == "android" ) {
            $appArn = self::GCM_ARN; 
        } elseif ( $platform == "ios" ) {
            $appArn = self::APNS_ARN;
        } else {
            return [
                "success" => false,
                "message" => "error"
            ];
        }

        $endPointList = [];

        $endPointList = $this->sns->listEndpointsByPlatformApplication([
            'PlatformApplicationArn' => $appArn
        ]);
        
        foreach( $endPointList["Endpoints"] as $endPoint ) {
            $endPointArn = $endPoint['EndpointArn'];
            try {
                $this->sns->publish([
                    'Message' => json_encode($message),
                    'MessageStructure'=>'json',
                    'TargetArn' => $endpointArn
                ]);

            } catch ( \Exception $error ) {
                
            }
        }
    }

    public function deleteSubscription($subscriptionArn)
    {
        try {
            $this->sns->unsubscribe($subscriptionArn);
            return [
                "success" => true,
                "message" => "OK"
            ];
        } catch (\Exception $error) {
            return [
                "success" => false,
                "message" => "error"
            ];
        }
    }

}

