<?php

class Common_model extends CI_Model {

    public $finalrole = array();

    public function __construct() {
        $this->load->database();
        $this->load->library('session');
    }

    /**
     * Fetch data from any table based on different conditions
     *
     * @access	public
     * @param	string
     * @param	string
     * @param	array
     * @return	bool
     */
    public function fetch_data($table, $fields = '*', $conditions = array(), $returnRow = false,$limit = null) {
        //Preparing query

        $this->db->select($fields);
        $this->db->from($table);

        //If there are conditions
        if (count($conditions) > 0) {
            $this->condition_handler($conditions);
        }
        $query = $this->db->get();

        //Return

        return $returnRow ? $query->row_array() : $query->result_array();
    }

    // for layout
    function load_views($customView, $data = array()) {
        $this->load->view('templates/header', $data);
        $a = $this->load->view($customView, $data);
        $this->load->view('templates/footer', $data);
    }

    // for layout after login
    function load_views_afterlogin($customView, $data = array()) {
        $this->load->view('layouts/header', $data);
        $this->load->view('layouts/left_menu', $data);
        $a = $this->load->view($customView, $data);
        $this->load->view('layouts/footer', $data);
    }

    /**
     * Handle different conditions of query
     *
     * @access	public
     * @param	array
     * @return	bool
     */
    private function condition_handler($conditions) {
        //Where

        if (array_key_exists('where', $conditions)) {

            //Iterate all where's
            foreach ($conditions['where'] as $key => $val) {

                $this->db->where($key, $val);
            }
        }

        //Where In
        if (array_key_exists('where_in', $conditions)) {

            //Iterate all where in's
            foreach ($conditions['where_in'] as $key => $val) {
                $this->db->where_in($key, $val);
            }
        }

        //Where Not In
        if (array_key_exists('where_not_in', $conditions)) {

            //Iterate all where in's
            foreach ($conditions['where_not_in'] as $key => $val) {
                $this->db->where_not_in($key, $val);
            }
        }

        //Having
        if (array_key_exists('having', $conditions)) {
            $this->db->having($conditions['having']);
        }

        //Group By
        if (array_key_exists('group_by', $conditions)) {
            $this->db->group_by($conditions['group_by']);
        }

        //Order By
        if (array_key_exists('order_by', $conditions)) {

            //Iterate all order by's
            foreach ($conditions['order_by'] as $key => $val) {
                $this->db->order_by($key, $val);
            }
        }

        //Like
        if (array_key_exists('like', $conditions)) {

            //Iterate all likes
            $i = 1;
            foreach ($conditions['like'] as $key => $val) {
                if ($i == 1) {
                    $this->db->like('LOWER(' . $key . ')', strtolower($val), 'after');
                    $this->db->or_like('LOWER('.$key.')',strtolower($val),'before');
                } else {
                    $this->db->or_like('LOWER(' . $key . ')', strtolower($val), 'after');
                }
                $i++;
            }
        }

        //Limit
        if (array_key_exists('limit', $conditions)) {
            //If offset is there too?
            if (count($conditions['limit']) == 1) {
                $this->db->limit($conditions['limit'][0]);
            } else {
                $this->db->limit($conditions['limit'][0], $conditions['limit'][1]);
            }
        }

        if (array_key_exists('findinset', $conditions)) {

            //Iterate all find in set 
            foreach ($conditions['findinset'] as $key => $val) {
                $this->db->where("FIND_IN_SET($val, $key)");
            }
        }
    }

    /**
     * For sending mail
     *
     * @access	public
     * @param	string
     * @param	string
     * @param	string
     * @param	boolean
     * @return	array
     */
    public function sendmail($email, $subject, $message = false, $single = true, $param = false, $templet = false) {

        if ($single == true) {
            $this->load->library('email');
        }

        $this->config->load('email');
        $this->email->set_newline("\r\n");

        $this->email->from($this->config->item('from'), $this->config->item('from_name'));
        $this->email->reply_to($this->config->item('repy_to'), $this->config->item('reply_to_name'));
        $this->email->to($email);
        $this->email->subject($subject);

        if ($param && $templet) {
            $body = $this->load->view('mail/' . $templet, $param, TRUE);
            //print_r($body);

            $this->email->message($body);
        } else {
            $this->email->message($message);
        }
        return $this->email->send() ? true : false;
    }

    /**
     * Update details in DB
     *
     * @access	public
     * @param	string
     * @param	array
     * @param	array
     * @return	string
     */
    public function update_single($table, $updates, $conditions = array()) {
        //If there are conditions

        if (count($conditions) > 0) {
            $this->condition_handler($conditions);
        }

        return $this->db->update($table, $updates);
        //echo $this->db->last_query(); die;
    }

    /*
     * function to get total table count
     */

    public function totalCount($table, $conditions = array()) {
        try {
            $this->db->select("COUNT(*) as `rows`");
            $this->db->from($table);
            if (count($conditions) > 0) {
                $this->condition_handler($conditions);
            }
        } catch (\Exception $err) { /*         * * Do Nothing */
        }
    
        $query = $this->db->get();
            $a = $this->db->last_query();

        return $query->row();
    }

    /**
     * Insert details in DB
     * @access	public
     * @param	string
     * @param	array
     * @return	int
     */
    public function insert($tablename, $insertdata = array()) {
        try {
            $this->db->insert($tablename, $insertdata);
            return $this->db->insert_id();
        } catch (Exception $ex) {
            
        }
    }

    /**
     * Insert details in DB
     * @access	public
     * @param	string
     * @param	array
     * @return	int
     */
    public function insertupdate($tablename, $insertdata = array(), $updatedata = array()) {
        try {
            $updatedata_string = "";
         foreach($updatedata as $key => $value){
            // $updatedata_string .= " ,".$key . "= " .$value;
               if (!is_bool($value))
                    $value = "'{$value}'";
                $updatedata_string.="{$key}" . "={$value},";
         }
         $updateddata_string = trim($updatedata_string,",");
            $sql = $this->db->insert_string($tablename, $insertdata) . ' ON DUPLICATE KEY UPDATE '.$updateddata_string ;
            $this->db->query($sql);
            $id = $this->db->insert_id();
            return $id;
        } catch (Exception $ex) {
            
        }
    }

}
