<?php

class Firmware_model extends CI_Model {

    public function __construct() {
        $this->load->database();
        $this->table_name = 'ai_firmware';
    }

    public function fetch_firmware_data($limit = false, $start = false, $condition = array()) {
        try {
            $this->db->select('ai_firmware.*');
            $this->db->from($this->table_name);
            $this->db->where('firmware_status!=', 2);
            if (isset($condition['firmware_version']) && $condition['firmware_version'] != '') {
                $this->db->like('firmware_version', $condition['firmware_version'], 'after');
                $this->db->or_like('firmware_version', " " . $condition['firmware_version']);
            }
            if (!empty($condition['sort_by']) && !empty($condition['sort_order'])) {
                $sort_by = $condition['sort_by'];
                $sort_order = $condition['sort_order'];
            } else {
                $sort_by = "firmware_version";
                $sort_order = "ASC";
            }

            $this->db->order_by('ai_firmware.' . $sort_by, $sort_order);
            if ($limit) {
                $this->db->limit($limit, $start);
            }
        } catch (Exception $e) {
            
        }
        $query = $this->db->get();
        $result = $query->result_array();

        if (count($result) > 0) {

            return $result;
        } else {
            return array();
        }
    }

    public function fetchFirmware($firmwareId)
    {
        $this->db->select("firmware_version, firmware_file")
            ->from($this->table_name)
            ->where("firmware_id", $firmwareId);
        
        $query = $this->db->get();
        $result = $query->result_array();

        if ( count($result) == 1 ) {
            return $result[0];
        } else {
            return [];
        }

    }


}
