<?php

class Notification_model extends CI_Model {

    public function __construct() {
        $this->load->database();
        $this->table_name = 'ai_notification';
         $this->load->model('Common_model');
    }

    /**
     * For Fetching notification log for oldest notification date
     * @param: condition 
     * return Notification log single row
     */
    public function fetch_notification_data($limit = false, $start = false, $condition = array()) {
        try {
            $this->db->select('ai_notification.*');
            $this->db->from($this->table_name);
            $this->db->where('notification_status !=', 2);
            if (isset($condition['title']) && $condition['title'] != '') {
                $this->db->like('title', $condition['title'], 'after');
                $this->db->or_like('title', " " . $condition['title']);
            }
            if (!empty($condition['sort_by']) && !empty($condition['sort_order'])) {
                $sort_by = $condition['sort_by'];
                $sort_order = $condition['sort_order'];
            } else {
                $sort_by = "title";
                $sort_order = "ASC";
            }
            $this->db->order_by('ai_notification.' . $sort_by, $sort_order);
            if ($limit) {
                $this->db->limit($limit, $start);
            }
        } catch (Exception $e) {
        }
        $query = $this->db->get();
        $result = $query->result_array();
        if (count($result) > 0) {
            return $result;
        } else {
            return array();
        }
    }

    /**
     * For Fetching notification list
     * @param: condition ,table
     * return All notification data
     */
    public function fetch_notification_log($condition = array()) {
        try {
            $this->db->select('*');
            $this->db->from('ai_notification_log');
            $this->db->where('notification_status =', 2);
            $sort_by = $condition['sort_by'];
            $sort_order = $condition['sort_order'];
            $this->db->order_by('ai_notification_log.' . $sort_by, $sort_order);
            $this->db->limit(1);
        } catch (Exception $ex) {
        }
        $query = $this->db->get();
        $result = $query->result_array();
      //  print_r($this->db->last_query());die;
        if (count($result) > 0) {

            return $result;
        } else {
            return array();
        }
    }

    /**
     * For sending android push notification
     * @param: device token,payload 
     * return success result
     */
    function andriodPush($deviceToken, $payload) {
   print_r($payload);
        $filtered_divecetoken =$deviceToken;
        ini_set('display_errors', '1');
       // $registrationIDs = array_values($filtered_divecetoken);
     $registrationIDs    = $deviceToken;
      $apiKey = 'AAAAfAd9V5I:APA91bHOa1zbsYA11-1r1Ll2BxbyWa26a4rAI0TctrmznJgtwFRgjO5RBjoSiW5paud-RIbuGWAnjwX9mgxOlJQvbSPiK6Gszs4PbuLPVjVXBm3WcgUWEdlro-P4vFft7bX6tbP00uaE';
        $url = 'https://android.googleapis.com/gcm/send';
        $push_data = json_decode($payload);
       
        $fields = array(
            'registration_ids' => $registrationIDs,
            'data' => $push_data,
        );

        $headers = array(
            'Authorization: key=' . $apiKey,
            'Content-Type: application/json'
        );
        $ch = curl_init();
        $u = curl_setopt($ch, CURLOPT_URL, $url);
        $p = curl_setopt($ch, CURLOPT_POST, true);
        $f = curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        $h = curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $t = curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $c = curl_setopt($ch, CURLOPT_VERBOSE, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $j = curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $jsonn = json_encode($fields);
        $result = curl_exec($ch);
        print_r($result);
        curl_close($ch);
        return $result;
    }

    /**
     * For sending ios push notification
     * @param: device token,payload 
     * return success result
     */
    function sendPushMessage($deviceToken, $payload) {
        try {
          
            $apnsHost = 'gateway.push.apple.com';
            $apnsPort = '2195';
            $apnsCert = $_SERVER['DOCUMENT_ROOT'] . '/admin/public/apns-pro.pem';
            $passPhrase = "";
            $streamContext = stream_context_create();
            stream_context_set_option($streamContext, 'ssl', 'local_cert', $apnsCert);
            stream_context_set_option($streamContext, 'ssl', 'passphrase', $passPhrase);
            $apnsConnection = stream_socket_client('ssl://' . $apnsHost . ':' . $apnsPort, $error, $errorString, 60, STREAM_CLIENT_CONNECT, $streamContext);
            
            if ($apnsConnection == false) {
                echo "Connection False";
                exit;
            } 
     
            //$payload = json_encode(array('aps'=>$payload));
             foreach ($deviceToken as $token) {
                 $token = pack('H*', trim($token));
                      if (!empty($payload)) {
                $apnsMessage = chr(0) . chr(0) . chr(32) . $token . chr(0) . chr(strlen($payload)) . $payload;
                if (fwrite($apnsConnection, $apnsMessage)) {
                    print_r("true");
                } else {
                }
            }
             }
          
        } catch (Exception $e) {
            echo "";
            print_r($e);
            die;
        }
    }

}
