<?php

class User_model extends CI_Model {

    public function __construct() {
        $this->load->database();
        $this->table_name = 'ai_user';
    }

    /**
     * For Fetching user list
     * @param: condition , limit
     * return User List
     */
    public function fetch_user_list($limit = false, $start = false, $condition = array(),$isCsv = false) {
        try {
            // $this->db->select('ai_user.*,as.device_token,as.device_id,as.os_version,as.platform,as.app_version');
            // $this->db->from($this->table_name);
            // $this->db->join('ai_session as', 'ai_user.user_id=as.user_id', 'LEFT');
            // $this->db->where('user_status !=', 2);
            if($isCsv){
                $col = 'ai_user.*,ais.*';
            }
            else{
                $col = 'ai_user.*';
            }
                       $this->db->select($col);
                       $this->db->from($this->table_name);
                       if($isCsv){
                        $this->db->join('ai_session ais', 'ai_user.user_id=ais.user_id', 'LEFT');
                        $this->db->join('ai_oolylog ail', 'ai_user.user_id=ais.user_id', 'LEFT');
                    }
                       $this->db->where('user_status !=', 2);

            if (isset($condition['search']) && $condition['search'] != '') {
                $this->db->like('first_name', $condition['search'], 'after');
                $this->db->or_like('first_name', " " . $condition['search']);
                 $this->db->like('email',$condition['search'],'after');
                  $this->db->or_like('email',$condition['search'],'before');
            }
            if (!empty($condition['sort_by']) && !empty($condition['sort_order'])) {

                $sort_by = $condition['sort_by'];
                $sort_order = $condition['sort_order'];
            } else {
                $sort_by = "registered_date";
                $sort_order = "ASC";
            }

            $this->db->order_by('ai_user.' . $sort_by, $sort_order);
            if ($limit) {
                $this->db->limit($limit, $start);
            }
        } catch (Exception $e) {
            
        }
        $query = $this->db->get();
      
        $result = $query->result_array();
        
        if (count($result) > 0) {

            return $result;
        } else {
            return array();
        }
    }

    /**
     * For Fetching user list
     * @param: condition , limit
     * return User List
     */
    public function fetch_user_detail($condition = array()) {
        $this->db->select('ais.*,ai_user.*');
        $this->db->from($this->table_name);
        $this->db->join('ai_session ais', 'ai_user.user_id=ais.user_id', 'Right');
        $this->db->where('ai_user.user_id=' . $condition['user_id']);
        $query = $this->db->get();
        $result = $query->result_array();
        // print_r($result);
        return $result;
    }

    /**
     * For Fetching platform and device tokens group by platform
     * @param: User Id
     * return User List
     */
    public function fetch_session_data($userid, $notification_type) {
        $this->db->query("SET @@group_concat_max_len = 15000;");
        //$this->db->select('ai_session.platform,GROUP_CONCAT(ai_session.device_token SEPARATOR ",") AS tokens');
        $this->db->select("ai_session.platform,GROUP_CONCAT(CONCAT_WS('|',ai_session.device_token,ai_session.user_id)  SEPARATOR ',')AS tokens");
        $this->db->from('ai_session');
        $this->db->group_by('platform');
        if ($userid != "All") {
            $user_id = explode(",", $userid);
            $this->db->where_in('user_id', $user_id);
        }
        $this->db->where($notification_type . '= 1');
        $query = $this->db->get();

        $result = $query->result_array();
        
        return $result;
    }

    public function get_all_users($lastinsertedid) {
        $this->db->select('DISTINCT(ai_user.user_id)');
        $this->db->from($this->table_name);
        $this->db->join('ai_session ais', 'ai_user.user_id=ais.user_id', 'Inner');
        $this->db->where('firmware_version_id <' . $lastinsertedid);
        $this->db->where('user_status !=', 2);
        $query = $this->db->get();
        $result = $query->result_array();
        $row = array_map('implode', $result);
        return $row;
    }
   
    public function ooly_data($condition) {
        $this->db->select('DISTINCT(ai_ooly.ooly_id),ai_ooly.*');
        $this->db->from('ai_ooly');
        $this->db->join('ai_oolylog ail', 'ai_ooly.ooly_id=ail.ooly_id', 'Inner');
        $this->db->where('user_id =' . $condition['user_id']);
        $this->db->order_by('ail.time','DESC');
        //$this->db->limit(1);
        $query = $this->db->get();
     
        $result = $query->result_array();
        return $result;
    }


}
