<?php

use Aws\Sns\SnsClient;

DEFINE('region', 'us-west-2');
DEFINE('iOS_AppArn', 'arn:aws:sns:us-west-2:399072541797:app/APNS/Ooly');
DEFINE('android_AppArn', 'arn:aws:sns:us-west-2:399072541797:app/GCM/Ooly');
// DEFINE('topic_AppArn', 'arn:aws:sns:us-west-2:399072541797:firmware_update');

class AwsPushNotification
{
    private $arn;

    public function __construct($arn)
    {
        $this->arn = $arn;
    }

    public function send_msg($android_message,$ios_message=array()){
        // Create a new Amazon SNS client
        $sns = SnsClient::factory(array(
            'credentials' => array(
                'key'    => awsAccessKey,
                'secret' => awsSecretKey,
            ),
            'region' => region,
            'version'=> 'latest'
            ));

        // region code samples: us-east-1, ap-northeast-1, sa-east-1, ap-southeast-1, ap-southeast-2, us-west-2, us-gov-west-1, us-west-1, cn-north-1, eu-west-1

        //$iOS_AppArn = "<iOS app's Application ARN>";
        $iOS_AppArn = iOS_AppArn;

        $android_AppArn = android_AppArn;

        // Get the application's endpoints
        $iOS_model = $sns->listEndpointsByPlatformApplication(array('PlatformApplicationArn' => $iOS_AppArn));
        $android_model = $sns->listEndpointsByPlatformApplication(array('PlatformApplicationArn' => $android_AppArn));

        // Display all of the endpoints for the iOS application

       // iOS: Send a message to each endpoint
        foreach ($iOS_model['Endpoints'] as $endpoint)
        {
            $endpointArn = $endpoint['EndpointArn'];

            try
            {
//                $ios_message=array(
//                    "APNS"=>json_encode(array(
//                        "aps"=>array(
//                                'alert'  =>array(
//                                    'title'=>"hello",
//                                    'body'=>"hello 123"
//                                ),
//                                "pushId"=>1,
//                                'badge'=>1,
//                                "sound"=>"default",
//                                'mutable-content'=>1
//                        ),
//                        "data"=>array(
//                            'attachment-url'=>'https://www.google.co.in/images/branding/googlelogo/2x/googlelogo_color_272x92dp.png'
//                        )
//                    ))
//                );
//                $ios_sandbox_message=array(
//                    "APNS_SANDBOX"=>json_encode(array(
//                        "aps"=>array(
//                                'alert'  =>array(
//                                    'title'=>"hello",
//                                    'body'=>"hello 123"
//                                ),
//                                "pushId"=>1,
//                                'badge'=>1,
//                                "sound"=>"default",
//                                'mutable-content'=>1
//                        ),
//                        "data"=>array(
//                            'attachment-url'=>'https://www.google.co.in/images/branding/googlelogo/2x/googlelogo_color_272x92dp.png'
//                        )
//                    ))
//                );
                $sns->publish(
                    array(
                        'Message' => json_encode($ios_message),
                        'MessageStructure'=>'json',
                        'TargetArn' => $endpointArn
                    ));
                echo "<pre><strong>Success:</strong> ".$endpointArn."<br/>";
            }
            catch (Exception $e)
            {
                echo "<pre><strong>Failed:</strong> ".$endpointArn."<br/><strong>Error:</strong> ".$e->getMessage()."<br/>";
            }
        }

        // android: Send a message to each endpoint
        foreach ($android_model['Endpoints'] as $endpoint)
        {
            $endpointArn = $endpoint['EndpointArn'];

            try
            {
//                $android_message=array(
//                    "GCM"=>json_encode(array(
//                        "data"=>array(
//                            "payload"=>array(
//                                "alert"=>"hello aws test",
//                                "pushId"=>1
//                            )
//                        )
//                    ))
//                );
                //echo json_encode($android_message);die;
                $sns->publish(
                        array(
                            'Message' => json_encode($android_message),
                            'MessageStructure'=>'json',
                            'TargetArn' => $endpointArn
                        ));

                echo "<pre><strong>Success:</strong> ".$endpointArn."<br/>";
            }
            catch (Exception $e)
            {
                echo "<pre><strong>Failed:</strong> ".$endpointArn."<br/><strong>Error:</strong> ".$e->getMessage()."<br/>";
            }
        }
    }
    
    public function send_bulk_msg($message){
        // Create a new Amazon SNS client
        $sns = SnsClient::factory(array(
            'credentials' => array(
                'key'    => awsAccessKey,
                'secret' => awsSecretKey,
            ),
            'region' => region,
            'version'=> 'latest'
            ));

        // region code samples: us-east-1, ap-northeast-1, sa-east-1, ap-southeast-1, ap-southeast-2, us-west-2, us-gov-west-1, us-west-1, cn-north-1, eu-west-1

        $topic_AppArn = $this->arn;
       
        try{
        $sns->publish(
                array(
                    'Message' => json_encode($message),
                    'MessageStructure'=>'json',
                    'TopicArn' => $topic_AppArn
                ));
            //echo "<pre><strong>Success:</strong> $topic_AppArn <br/>";
        }catch (Exception $e)
        {
            //echo "<pre><strong>Failed: Error:</strong> ".$e->getMessage()."<br/>";
        }


    }
    
    public function createArn($device_token,$user_id,$arn){
        
        $sns = SnsClient::factory(array(
                'credentials' => array(
                    'key'    => awsAccessKey,
                    'secret' => awsSecretKey,
                ),
                'region' => region,
                'version'=> 'latest'
            ));

        if($arn=='android'){
            $platformApplicationArn=android_AppArn;
        }else{
            $platformApplicationArn=iOS_AppArn;
        }
        try{
        $result = $sns->createPlatformEndpoint(array(
                    'PlatformApplicationArn' => $platformApplicationArn,
                    'CustomUserData'=>$user_id,
                    'Token' => $device_token,
        ));
        //echo "<pre>";print_r($result);die;
        return $result;
        }
        catch (Exception $e){
            echo "<pre>";print_r($e);die;
        }
    }
    
    public function createTopicArn($endpoint_arn,$Protocol='Application'){
        try{
            $sns = SnsClient::factory(array(
                'credentials' => array(
                    'key'    => awsAccessKey,
                    'secret' => awsSecretKey,
                ),
                'region' => region,
                'version'=> 'latest'
                ));

            $TopicArn = $this->arn;


            $result = $sns->subscribe(array(
                'Endpoint' => $endpoint_arn,
                'Protocol' => $Protocol, // REQUIRED
                'TopicArn' => $TopicArn, // REQUIRED
            ));
            return $result;
        }
        catch (Exception $e){
            echo "<pre>";print_r($e);die;
        }
    }
}
?>
