<?php

namespace AppInventiv;

use AppInventiv\database\Db;
use AppInventiv\model\Usermodel;
use AppInventiv\Rest;
use \Exception;

class Content extends Rest {

    private $department;
    private $config;
    private $db;
    private $Usermodel;

    public function __construct() {
        parent::__construct();
        $this->db = new Db();
        $this->Usermodel = new Usermodel();
        $this->processApi();
    }

    private function processApi() {
        $func = strtolower(trim(str_replace("/", "", $_REQUEST['rquest'])));
        if ((int) method_exists($this, $func) > 0)
            $this->$func();
        else
            $this->response('', 404);    // If the method not exist with in this class, response would be "Page not found".
    }

    private function content() {
        try {
            // Cross validation if the request method is POST else it will return "Not Acceptable" status
            if ($this->get_request_method() != "GET") {
                $this->response([], 405);
            }
            $data = $this->_request;
            $this->checkEmptyParameter($data, ["slug"]);
            $this->checkEmptyParameter($data, ["lang"]);
            $this->db->beginTransaction();
            $isContentExist = $this->Usermodel->getContent(["slug" => $data['slug']]);
                  if (false == $isContentExist) {
                throw new Exception("Invalid Slug || 222");
            }
            if($data['lang']=="eng"){
            $content = $isContentExist['content_eng'];
        }
        else{
            $content = $isContentExist['content_fer'];
        }
       
        } catch (Exception $ex) {

            $this->db->rollBack();
            $error = $ex->getMessage();
            list($msg, $code) = explode(" || ", $error);
            $this->response([], $code, [], $msg);
        }
             $this->response($content, 200, [], "Success");
    }
        private function json($data) {
        if (is_array($data)) {
            return json_encode($data);
        }
    }

}
