<?php
namespace AppInventiv;
use AppInventiv\database\Db;
use AppInventiv\model\Usermodel;
use AppInventiv\Uploadexception;
use AppInventiv\Rest;
use \Exception;

class Demoschedules extends Rest {

    private $department;
    private $config;
    private $db;
    private $Usermodel;

    public function __construct() {
        parent::__construct();
        $this->db = new Db();
        $this->Usermodel = new Usermodel();
        $this->processApi();
    }

    private function processApi() {

        $func = strtolower(trim(str_replace("/", "", $_REQUEST['rquest'])));

        if ((int) method_exists($this, $func) > 0)
            $this->$func();
        else
            $this->response('', 404);    // If the method not exist with in this class, response would be "Page not found".
    }

    private function demoschedules() {
        try {
            // Cross validation if the request method is POST else it will return "Not Acceptable" status
            if ($this->get_request_method() != "GET") {
                $this->response([], 405);
            }
            $header_arr = getallheaders();
            $header_arr = array_change_key_case($header_arr, CASE_LOWER);
            if (isset($header_arr['authtoken']) && !empty($header_arr['authtoken'])) {
                $session_id = $header_arr['authtoken'];
            } else {
                $this->response([], 219);
            }
            $data = $this->_request;
           //$this->checkEmptyParameter($data, ["ooly_id"]);
            $this->db->beginTransaction();
            $isSessionExist = $this->Usermodel->getSessionRecord(["session_id" => $session_id]);
            if (false == $isSessionExist) {
                throw new Exception("Invalid Request || 219");
            }
            $user_id = $isSessionExist['user_id'];
            $isUserExist = $this->Usermodel->getRecordExists(["user_id" => $user_id]);
            if ($isUserExist['user_status'] == 2) {
                throw new Exception("Invalid User || 218");
            }
           // $device_id = $isSessionExist['device_id'];
            $schedule_data = $this->Usermodel->getDemoScheduleRecord();
            if(empty($schedule_data)){
                 throw new Exception("No schedule found || 222");
            }
        } catch (Exception $ex) {
            $this->db->rollBack();
            $error = $ex->getMessage();
            list($msg, $code) = explode(" || ", $error);
            $this->response([], $code, [], $msg);
        }
          $this->response($schedule_data, 200, [], 'Success');
    }

    /*
     * 	Encode array into JSON
     */

    private function json($data) {
        if (is_array($data)) {
            return json_encode($data);
        }
    }

}   
