<?php

namespace AppInventiv;

use AppInventiv\database\Db;
use AppInventiv\model\Usermodel;
use AppInventiv\Rest;
use \Exception;

class Editprofile extends Rest {

    private $department;
    private $config;
    private $db;
    private $Usermodel;

    public function __construct() {

        parent::__construct();

        $this->db = new Db();
        $this->Usermodel = new Usermodel();
        $this->processApi();
    }

    private function processApi() {

        $func = strtolower(trim(str_replace("/", "", $_REQUEST['rquest'])));


        if ((int) method_exists($this, $func) > 0)
            $this->$func();
        else
            $this->response('', 404);    // If the method not exist with in this class, response would be "Page not found".
    }

    private function editprofile() {

        try {
            // Cross validation if the request method is POST else it will return "Not Acceptable" status
            if ($this->get_request_method() != "POST") {
                
                $this->response([], 405);
            }
         
            $header_arr = getallheaders();
            $header_arr = array_change_key_case($header_arr, CASE_LOWER);
            if (isset($header_arr['authtoken']) && !empty($header_arr['authtoken'])) {
                $session_id = $header_arr['authtoken'];
            } else {
                $this->response([], 210);
            }
            $data = $this->_request;

            $this->checkEmptyParameter($data, ["action"]);

            //Validate Data
            //$this->validateData(["email" => $data["email"]]);
            $pArray = ["email", "first_name"];
            $data = $this->defineDefaultValue($pArray, $data);
            $this->db->beginTransaction();
            $isSessionExist = $this->Usermodel->getSessionRecord(["session_id" => $session_id]);
            if (false == $isSessionExist) {
                throw new Exception("Invalid Request || 210");
            }
            $user_id = $isSessionExist['user_id'];
            $isUserExist = $this->Usermodel->getRecordExists(["user_id" => $user_id]);
            if ($isUserExist['user_status'] == 2) {
                throw new Exception("Invalid User || 212");
            }
            $userimage = $isUserExist['image'];

           define("UPLOAD_DIR", $_SERVER['DOCUMENT_ROOT'] . "/admin/public/uploads/userimages/");

            if ($data["action"] == "remove") {
                if ($userimage != "") {
                    $path = UPLOAD_DIR . $userimage;
                    chmod($path, 0777);
                    unlink($path);
                    $name = "";
                }
            }

            if ($data["action"] == "add") {
                if ($userimage != "") {
                    $path = UPLOAD_DIR . $userimage;
                    //$filename = '/path/to/foo.txt';
                    if (file_exists($path)) {

                   chmod($path, 0777);
                    unlink($path);
                    } 

                   
                }
                if (isset($_FILES['profile_image']) && !empty($_FILES['profile_image'])) {
                               
                    if ($_FILES['profile_image']['error'] === UPLOAD_ERR_OK) {
                        $format = array("IMAGETYPE_JPG", "3", "IMAGETYPE_JPEG", "2", "1", "IMAGETYPE_PNG");
                        if (!in_array(exif_imagetype($_FILES['profile_image']['tmp_name']), $format)) {
                            throw new Exception("Only Jpg, png file required || 209");
                        }
                        $filename = explode(".", $_FILES["profile_image"]['name']);

                        $dot_count = count($filename);
                        $ext = $filename[$dot_count - 1];
                        $name = time() . "." . $ext;


                        $success = move_uploaded_file($_FILES["profile_image"]["tmp_name"], UPLOAD_DIR . $name);
                        if (!$success) {
                            throw new Exception("User profile image could not be save || 209");
                        }

                        // set proper permissions on the new file
                        chmod(UPLOAD_DIR . $name, 0644);
                    } else {
                        throw new Uploadexception($_FILES['profile_image']['error']);
                    }
                }
            }
            if ($data['action'] == "no_action") {
                $name = $userimage;
            }

            $user = [ "first_name" => $data["first_name"]];
            if (isset($name)) {
                $user["image"] = $name;
            }

            $condition = 'user_id =' . $user_id;
            $query_run = $this->db->update('ai_user', $user, $condition);
            $this->db->executeTransaction();
            $isUserExist = $this->Usermodel->getRecordExists(["user_id" => $user_id]);
            $arr = [
                "first_name" => $isUserExist["first_name"],
                "email" => $isUserExist["email"],
                "image" => isset($isUserExist["image"]) && !empty($isUserExist["image"]) ? "http://" . $_SERVER['SERVER_NAME'] . "/admin/public/uploads/userimages/". $isUserExist["image"] : ""
            ];
        } catch (Exception $ex) {

            $this->db->rollBack();
            $error = $ex->getMessage();
            list($msg, $code) = explode(" || ", $error);
            $this->response([], $code, [], $msg);
        }
        $this->response($arr, 200, [], "Profile updated successfully");
    }

    /*
     * 	Encode array into JSON
     */

    private function json($data) {
        if (is_array($data)) {
            return json_encode($data);
        }
    }

}

?>