<?php

namespace AppInventiv;

use AppInventiv\database\Db;
use AppInventiv\model\Usermodel;
use AppInventiv\Uploadexception;
use AppInventiv\Rest;
use \Exception;

class Editschedule extends Rest {

    private $department;
    private $config;
    private $db;
    private $Usermodel;

    public function __construct() {
        parent::__construct();
        $this->db = new Db();
        $this->Usermodel = new Usermodel();
        $this->processApi();
    }

    private function processApi() {

        $func = strtolower(trim(str_replace("/", "", $_REQUEST['rquest'])));

        if ((int) method_exists($this, $func) > 0)
            $this->$func();
        else
            $this->response('', 404);    // If the method not exist with in this class, response would be "Page not found".
    }

    private function editschedule() {
        try {
            // Cross validation if the request method is POST else it will return "Not Acceptable" status
            if ($this->get_request_method() != "POST") {
                $this->response([], 405);
            }
            
            $header_arr = getallheaders();
            $header_arr = array_change_key_case($header_arr, CASE_LOWER);
            //Validate session
            if (isset($header_arr['authtoken']) && !empty($header_arr['authtoken'])) {
                $session_id = $header_arr['authtoken'];
            } else {
                $this->response([], 219);
            }
            $data = $this->_request;
              //Check requirement parameter missing
            //Total Input Array
            // Required Keys in array
            $this->checkEmptyParameter($data, ["schedule_id"]);
               //Possible Array
            $pArray = ["ooly_id", "device_id", "light_status", "start_time", "label", "color", "repeat_day", "manual_switch", "notification", "light_intensity_disable_blue", "light_intensity_color_transition","light_intensity_transition_duration","lantern_mode_status","lantern_mode_color","lantern_mode_disable_blue","lantern_mode_color_transition","lantern_mode_transition_duration","lantern_mode_duration","shake_mode","max_uses","user_id", "updated_date","local_id"];
            $data = $this->defineDefaultValue($pArray, $data);
            $this->db->beginTransaction();
           if ($session_id != "1011") {
                $isSessionExist = $this->Usermodel->getSessionRecord(["session_id" => $session_id]);
                if (false == $isSessionExist) {
                    throw new Exception("Invalid Request || 219");
                }
                $user_id = $isSessionExist['user_id'];
                $isUserExist = $this->Usermodel->getRecordExists(["user_id" => $user_id]);
                if ($isUserExist['user_status'] == 2) {
                    throw new Exception("Invalid User || 218");
                }

                $device_id = $isSessionExist['device_id'];
            } else {
                $user_id = "1011";
                $device_id = "1011";
            }
            $isScheduleExist = $this->Usermodel->getScheduleRecord(["schedule_id" => $data["schedule_id"]]);
            if (!isset($isScheduleExist) || empty($isScheduleExist)) {
                throw new Exception("Invalid Schedule || 214");
            }
            $device_id = $isSessionExist['device_id'];
            $schedule_list = [
                "ooly_id" => $data["ooly_id"],
                "device_id" => $device_id,
                "light_status" => isset($data['light_status'])&&!empty($data['light_status'])?$data['light_status']:$isScheduleExist[0]['light_status'],
                "start_time" =>  isset($data['start_time'])&&!empty($data['start_time'])?$data['start_time']:$isScheduleExist[0]['start_time'],
                "label" =>  isset($data['label'])&&!empty($data['label'])?$data['label']:$isScheduleExist[0]['label'],
                "color" =>  isset($data['color'])&&!empty($data['color'])?$data['color']:$isScheduleExist[0]['color'],
                "repeat_day" =>  isset($data['repeat_day'])&&!empty($data['repeat_day'])?$data['repeat_day']:$isScheduleExist[0]['repeat_day'],
                "manual_switch" =>  isset($data['manual_switch'])&&!empty($data['manual_switch'])?$data['manual_switch']:$isScheduleExist[0]['manual_switch'],
                "notification" =>  isset($data['notification'])&&!empty($data['notification'])?$data['notification']:$isScheduleExist[0]['notification'],
                "light_intensity_disable_blue" => isset($data['light_intensity_disable_blue'])&&!empty($data['light_intensity_disable_blue'])?$data['light_intensity_disable_blue']:$isScheduleExist[0]['light_intensity_disable_blue'],
                "light_intensity_color_transition" => isset($data['light_intensity_color_transition'])&&!empty($data['light_intensity_color_transition'])?$data['light_intensity_color_transition']:$isScheduleExist[0]['light_intensity_color_transition'],
                "light_intensity_transition_duration" => isset($data['light_intensity_transition_duration'])&&!empty($data['light_intensity_transition_duration'])?$data['light_intensity_transition_duration']:$isScheduleExist[0]['light_intensity_transition_duration'],
                "lantern_mode_status" =>isset( $data['lantern_mode_status'])&&!empty($data['lantern_mode_status'])?$data['lantern_mode_status']:$isScheduleExist[0]['lantern_mode_status'],
                "lantern_mode_color" =>isset( $data['lantern_mode_color'])&&!empty($data['lantern_mode_color'])?$data['lantern_mode_color']:$isScheduleExist[0]['lantern_mode_color'],
                "lantern_mode_disable_blue" => isset($data['lantern_mode_disable_blue'])&&!empty($data['lantern_mode_disable_blue'])?$data['lantern_mode_disable_blue']:$isScheduleExist[0]['lantern_mode_disable_blue'],
                "lantern_mode_color_transition" =>isset( $data['lantern_mode_color_transition'])&&!empty($data['lantern_mode_color_transition'])?$data['lantern_mode_color_transition']:$isScheduleExist[0]['lantern_mode_color_transition'],
                "lantern_mode_transition_duration" => isset($data['lantern_mode_transition_duration'])&&!empty($data['lantern_mode_transition_duration'])?$data['lantern_mode_transition_duration']:$isScheduleExist[0]['lantern_mode_transition_duration'],
                "lantern_mode_duration" => isset($data['lantern_mode_duration'])&&!empty($data['lantern_mode_duration'])?$data['lantern_mode_duration']:$isScheduleExist[0]['lantern_mode_duration'],
                "shake_mode"=> isset($data['shake_mode'])&&!empty($data['shake_mode'])?$data['shake_mode']:$isScheduleExist[0]['shake_mode'],
                "user_id" => $user_id,
                "updated_date" => date("Y-m-d"),
                    //"image"=>$name,
                    //"status" => 1
            ];
            $condition = 'schedule_id='.$data['schedule_id'];
            $query_run = $this->db->update('ai_schedule_list', $schedule_list, $condition);
           
            $this->db->executeTransaction();
            $isScheduleExist = $this->Usermodel->getScheduleRecord(["schedule_id" => $data["schedule_id"]]);
            $arr = [
                "ooly_id" => $isScheduleExist[0]["ooly_id"],
                "light_status" => $isScheduleExist[0]["light_status"],
                "start_time" => $isScheduleExist[0]['start_time'],
                "label" => $isScheduleExist[0]['label'],
                "color" => $isScheduleExist[0]['color'],
                "repeat_day" => $isScheduleExist[0]['repeat_day'],
                "manual_switch" => $isScheduleExist[0]['manual_switch'],
                "notification" => $isScheduleExist[0]['notification'],
                "light_intensity_disable_blue" => $isScheduleExist[0]['light_intensity_disable_blue'],
                "light_intensity_color_transition" => $isScheduleExist[0]['light_intensity_color_transition'],
                "light_intensity_transition_duration" => $isScheduleExist[0]['light_intensity_transition_duration'],
                "lantern_mode_status" => $isScheduleExist[0]['lantern_mode_status'],
                "lantern_mode_color" => $isScheduleExist[0]['lantern_mode_color'],
                "lantern_mode_disable_blue" => $isScheduleExist[0]['lantern_mode_disable_blue'],
                "lantern_mode_color_transition" => $isScheduleExist[0]['lantern_mode_color_transition'],
                "lantern_mode_transition_duration" => $isScheduleExist[0]['lantern_mode_transition_duration'],
                "lantern_mode_duration" => $isScheduleExist[0]['lantern_mode_duration'],
                "shake_mode" => $isScheduleExist[0]['shake_mode'],
                "user_id" => $user_id,
                "updated_date" => date("Y-m-d"),
            ];


            // $device_id = $isSessionExist['device_id'];
        } catch (Exception $ex) {
            $this->db->rollBack();
            $error = $ex->getMessage();
            list($msg, $code) = explode(" || ", $error);
            $this->response([], $code, [], $msg);
        }
        $this->response($arr, 200, [], 'Success');
    }

    /*
     * 	Encode array into JSON
     */

    private function json($data) {
        if (is_array($data)) {
            return json_encode($data);
        }
    }

}
