<?php

namespace AppInventiv;

use AppInventiv\database\Db;
use AppInventiv\model\Usermodel;
use AppInventiv\Rest;
use \Exception;

class Guestlogin extends Rest {

    private $department;
    private $config;
    private $db;
    private $Usermodel;

    /**
     * @param $department
     * @param array $config
     */
    public function __construct() {
        parent::__construct();

        $this->db = new Db();
        $this->Usermodel = new Usermodel();
        $this->processApi();
    }

    private function processApi() {

        $func = strtolower(trim(str_replace("/", "", $_REQUEST['rquest'])));

        if ((int) method_exists($this, $func) > 0)
            $this->$func();
        else
            $this->response('', 404);    // If the method not exist with in this class, response would be "Page not found".
    }

    /**
     * @func: guestlogin
     * @params null
     * @throws Exception
     * @return  Response
     */
    private function guestlogin() {
        try {
            // Cross validation if the request method is POST else it will return "Not Acceptable" status
            if ($this->get_request_method() != "POST") {
                $this->response([], 405);
            }
            //Get all request Data
            $data = $this->_request;
            $pArray = [ "device_id", "device_token", "ipaddress", "device_model", "imei", "os_version", "platform", "network", "app_version", "longitude", "latitude", "country_code", "region", "city", "postal_code",
            ];
            $data = $this->defineDefaultValue($pArray, $data);
            $this->db->beginTransaction();
            $isUserExist = $this->Usermodel->getSessionRecord(["device_id" => $data['device_id']]);
                 if (false !== $isUserExist) {
                $condition = 'user_id =' . $isUserExist['user_id'];
                //$data = ['device_token'=> $data['device_token']]; 
                $this->db->delete('ai_session',$condition);
                $user_id = $isUserExist['user_id'];
            }
          else{
            $user = [
                "first_name" => $data["device_id"],
                "is_Guest" => 1,
                //"image"=>$name,
                "status" => 1
            ];
            $user_id = $this->db->insert('ai_user', $user);
          }
            $access_token = $this->create_access_token("1011", "");
            list($private_key, $public_key) = explode("||", $access_token);
            $session = [
                "user_id" => $user_id,
                "device_id" => $data["device_id"],
                "device_token" => $data["device_token"],
                "ipaddress" => $data["ipaddress"],
                "device_model" => $data["device_model"],
                "imei" => $data["imei"],
                "os_version" => $data["os_version"],
                "platform" => $data["platform"],
                "network" => $data["network"],
                "app_version" => $data['app_version'],
                "login_time" => time(),
                //"country_code" => $data['country_code'],
                "public_key" => $public_key,
                "private_key" => $private_key,
                "Is_Guest" => 1
            ];
            $session_id = $this->db->insert('ai_session', $session);
            $arr = [
                "public_key" => $public_key,
                "private_key" => $private_key,
                "session_id" => $session_id
            ];
       
            $this->db->executeTransaction();
        } catch (Exception $e) {

            $this->db->rollBack();
            $error = $e->getMessage();

            list($msg, $code) = explode(" || ", $error);
            $this->response([], $code, [], $msg);
        }
        $this->response($arr, 200, [], 'Guest User is logged in successfully.');
    }

}
