<?php

namespace AppInventiv;

use AppInventiv\database\Db;
use AppInventiv\model\Usermodel;
use AppInventiv\Rest;
use \Exception;

class Notificationsetting extends Rest {

    private $config;
    private $db;
    private $Usermodel;
    private $mail;

    public function __construct() {
        parent::__construct();

        $this->db = new Db();
        $this->Usermodel = new Usermodel();
        $this->processApi();
    }

    private function processApi() {

        $func = strtolower(trim(str_replace("/", "", $_REQUEST['rquest'])));
       

        if ((int) method_exists($this, $func) > 0)
            $this->$func();
        else
            $this->response('', 404);    // If the method not exist with in this class, response would be "Page not found".
    }

    private function notificationsetting() {
        try {
            if ($this->get_request_method() != "POST") {
                $this->response([], 405);
            }
            $header_arr = getallheaders();
            $header_arr = array_change_key_case($header_arr, CASE_LOWER);
            if (isset($header_arr['authtoken']) && !empty($header_arr['authtoken'])) {
                $session_id = $header_arr['authtoken'];
                //print_r($session_id);
            } else {
                $this->response([], 219);
            }
            $data = $this->_request;

            
            $this->checkEmptyParameter($data, ["notification_key","notification_status"]);
            $this->db->beginTransaction();
           
            $isSessionExist = $this->Usermodel->getSessionRecord(["session_id" => $session_id]);
               if (false == $isSessionExist) {
                throw new Exception("Invalid Request || 219");
            }

            if ( $data["notification_key"] == "light_period" ) {
                $data["notification_key"] = "light_period_start";
            }

            $user_id = $isSessionExist['user_id'];
            $notification_key  = $data["notification_key"];
            $setting = array($notification_key => $data['notification_status']);
            
             // $sns = new SNSPush("arn:aws:sns:us-west-2:634381625056:firmware_update", "application");
            if ( $data["notification_key"] == "firmware_update" && 1 === (int)$data["notification_status"] ) {
                $sns = new SNSPush("arn:aws:sns:us-west-2:634381625056:firmware_update", "application");
                $endPoint = "";
                $endPointFlag = false;
                if ( empty(trim($isSessionExist["device_arn"])) ) {
                    $response = $sns->addDeviceEndPoint(
                        trim($isSessionExist["device_token"]),
                        strtolower($isSessionExist["platform"]),
                        $isSessionExist["user_id"]
                    );
                    //can be subject to conditional assignment
                    if ( $response["success"] ) {
                        $endPoint = $response["result"]["EndpointArn"];
                        $setting["device_arn"] = $response["result"]["EndpointArn"];
                        $endPointFlag = true;
                    }
                } else {
                    $endPoint = $isSessionExist["device_arn"];
                    $endPointFlag = true;
                }

                
                if ( $endPointFlag ) {
                    $resp = $sns->subscribeDevicetoTopic($endPoint);
                    if ( $resp["success"] ) {
                        $setting["firmware_arn"] = $resp["result"]["SubscriptionArn"];
                    }
                }
            } else if ( $data["notification_key"] == "firmware_update" && 2 === (int)$data["notification_status"] ) {
                if ( !empty($isSessionExist["firmware_arn"]) ) {
                    $sns = new SNSPush("", "application");
                    $sns->deleteSubscription($isSessionExist["firmware_arn"]);
                    $setting["firmware_arn"] = "";
                }
            }
            
           $condition = 'session_id =' . $session_id;
           $query_run = $this->db->update('ai_session', $setting, $condition);
           if ( isset($setting["firmware_arn"]) ) {
                unset($setting["firmware_arn"]);
           }
           if ( isset($setting["device_arn"]) ) {
                unset($setting["device_arn"]);
           }
          $query_run = $this->db->update('ai_user',$setting,'user_id ='.$user_id);
            $this->db->executeTransaction();
               $isUserExist = $this->Usermodel->getRecordExists(["user_id" => $user_id]);
            $notification_array = array($data['notification_key']=> $isUserExist[$data['notification_key']] );
            
        } catch (Exception $ex) {
              $this->db->rollBack();
            $error = $ex->getMessage();
            list($msg, $code) = explode(" || ", $error);
            $this->response([], $code, [], $msg);
        }
        $this->response($notification_array, 200, [], "Success");
    }
}
