<?php

namespace AppInventiv;

use AppInventiv\database\Db;
use AppInventiv\model\Usermodel;
use AppInventiv\Rest;
use \Exception;

class Oolyrecord extends Rest {

    private $config;
    private $db;
    private $Usermodel;

    public function __construct() {
        parent::__construct();
        $this->db = new Db();
        $this->Usermodel = new Usermodel();
        $this->processApi();
    }

    private function processApi() {
        $func = strtolower(trim(str_replace("/", "", $_REQUEST['rquest'])));
        if ((int) method_exists($this, $func) > 0)
            $this->$func();
        else
            $this->response('', 404);    // If the method not exist with in this class, response would be "Page not found".
    }
    /**
     * @function oolyrecord
     * @description store ooly ino in ooly table and store user ooly connection log in oolylog table
     */
    private function oolyrecord() {
        try {
            if ($this->get_request_method() != "POST") {
                $this->response([], 405);
            }
            $header_arr = getallheaders();
            $header_arr = array_change_key_case($header_arr, CASE_LOWER);
            if (isset($header_arr['authtoken']) && !empty($header_arr['authtoken'])) {
                $session_id = $header_arr['authtoken'];
            } else {
                $this->response([], 219);
            }
            $data = $this->_request;
            $this->checkEmptyParameter($data, ["ooly_id", "ooly_name", "model_number", "serial_number", "hardware_revision", "firmware_revision"]);
            $this->db->beginTransaction();
            $isSessionExist = $this->Usermodel->getSessionRecord(["session_id" => $session_id]);
            if (false == $isSessionExist) {
                throw new Exception("Invalid Request || 219");
            }
            $user_id = $isSessionExist['user_id'];
            $newdata = $data;
            unset($data['time']);
            $oolydata = array("ooly_name" => $data["ooly_name"], "firmware_revision" => $data["firmware_revision"], "hardware_revision" => $data["hardware_revision"]);
            $lastinsertid = $this->db->insertupdate('ai_ooly', $data, $oolydata);
            $logdata = array("ooly_id"=>$newdata["ooly_id"],"user_id"=>$user_id,"time"=>$newdata['time']);
            $lastinsertid = $this->db->insert("ai_oolylog",$logdata);
            $this->db->executeTransaction();
            $this->response([], 200, [], 'Success');
        }    
        catch (Exception $ex) {
            $this->db->rollBack();
            $error = $ex->getMessage();
            list($msg, $code) = explode(" || ", $error);
            $this->response([], $code, [], $msg);
        }
    }

}
