<?php

namespace AppInventiv;

use AppInventiv\database\Db;
use AppInventiv\model\Usermodel;
use AppInventiv\Uploadexception;
use AppInventiv\Rest;
use \Exception;

class Schedulesave extends Rest {

    private $department;
    private $config;
    private $db;
    private $Usermodel;

    public function __construct() {
        parent::__construct();
        $this->db = new Db();
        $this->Usermodel = new Usermodel();
        $this->processApi();
    }

    private function processApi() {

        $func = strtolower(trim(str_replace("/", "", $_REQUEST['rquest'])));

        if ((int) method_exists($this, $func) > 0)
            $this->$func();
        else
            $this->response('', 404);    // If the method not exist with in this class, response would be "Page not found".
    }

    private function schedulesave() {
        try {
            // Cross validation if the request method is POST else it will return "Not Acceptable" status
            if ($this->get_request_method() != "POST") {
                $this->response([], 405);
            }
            $header_arr = getallheaders();
            $header_arr = array_change_key_case($header_arr, CASE_LOWER);
             //Validate session
            if (isset($header_arr['authtoken']) && !empty($header_arr['authtoken'])) {
                $session_id = $header_arr['authtoken'];
            } else {
                $this->response([], 219);
            }
              //Get all request Data
            $data = $this->_request;
             //Check requirement parameter missing
            //Total Input Array
            // Required Keys in array
            $this->checkEmptyParameter($data, ["start_time", "color","ooly_id","repeat_day"]);
             //Possible Array
            $pArray = ["ooly_id", "device_id", "light_status", "start_time", "label", "color", "repeat_day", "manual_switch", "notification", "light_intensity_disable_blue", "light_intensity_color_transition","light_intensity_transition_duration","lantern_mode_status","lantern_mode_color","lantern_mode_disbale_blue","lantern_mode_color_transition","lantern_mode_transition_duration","lantern_mode_duration","shake_mode","max_uses","user_id", "updated_date","local_id"];
            $data = $this->defineDefaultValue($pArray, $data);
            $this->db->beginTransaction();
            if($session_id!="1011"){
            $isSessionExist = $this->Usermodel->getSessionRecord(["session_id" => $session_id]);
            if (false == $isSessionExist) {
                throw new Exception("Invalid Request || 219");
            }
            $user_id = $isSessionExist['user_id'];
            $isUserExist = $this->Usermodel->getRecordExists(["user_id" => $user_id]);
            if ($isUserExist['user_status'] == 2) {
                throw new Exception("Invalid User || 218");
            }
            
            $device_id = $isSessionExist['device_id'];
            }
            else{
                $user_id = "1011";
                $device_id = "1011";        
            }
            $schedule_list = [
                "ooly_id" => $data["ooly_id"],
                "device_id" => $device_id,
                "light_status" => $data["light_status"],
                "start_time" => $data['start_time'],
                "label" => $data['label'],
                "color" => $data['color'],
                "repeat_day" => $data['repeat_day'],
                "manual_switch" => $data['manual_switch'],
                "notification" => $data['notification'],
                "light_intensity_disable_blue" => $data['light_intensity_disable_blue'],
                "light_intensity_color_transition" => $data['light_intensity_color_transition'],
                "light_intensity_transition_duration" => $data['light_intensity_transition_duration'],
                "lantern_mode_status" => $data['lantern_mode_status'],
                "lantern_mode_color" => $data['lantern_mode_color'],
                "lantern_mode_disbale_blue" => $data['lantern_mode_disbale_blue'],
                "lantern_mode_color_transition" => $data['lantern_mode_color_transition'],
                "lantern_mode_transition_duration" => $data['lantern_mode_transition_duration'],
                "lantern_mode_duration" => $data['lantern_mode_duration'],
                "shake_mode"=> $data['shake_mode'],
                "user_id" => $user_id,
                "created_date" =>  date("Y-m-d"),
            ];
            $schedule_id = $this->db->insert('ai_schedule_list', $schedule_list);
            $arr = ["schedule_id" => $schedule_id,"local_id" => $data['local_id']];
             $this->db->executeTransaction();
        } catch (Exception $ex) {
            $this->db->rollBack();
            $error = $ex->getMessage();
            list($msg, $code) = explode(" || ", $error);
            $this->response([], $code, [], $msg);
        }
     
        $this->response($arr, 200, [], "Your Schedule has been saved");
    }
        /*
     * 	Encode array into JSON
     */

    private function json($data) {
        if (is_array($data)) {
            return json_encode($data);
        }
    }


}
