<?php

namespace AppInventiv;

use AppInventiv\database\Db;
use AppInventiv\model\Usermodel;
use AppInventiv\Uploadexception;
use AppInventiv\Rest;
use \Exception;

class Schedulesync extends Rest {

    private $department;
    private $config;
    private $db;
    private $Usermodel;

    public function __construct() {
        parent::__construct();
        $this->db = new Db();
        $this->Usermodel = new Usermodel();
        $this->processApi();
    }

    private function processApi() {
        $func = strtolower(trim(str_replace("/", "", $_REQUEST['rquest'])));
        if ((int) method_exists($this, $func) > 0)
            $this->$func();
        else
            $this->response('', 404);    // If the method not exist with in this class, response would be "Page not found".
    }

    private function schedulesync() {
        try {
            if ($this->get_request_method() != "PUT") {
                $this->response([], 405);
            }
            $header_arr = getallheaders();
            $header_arr = array_change_key_case($header_arr, CASE_LOWER);
            //Validate session
            if (isset($header_arr['authtoken']) && !empty($header_arr['authtoken'])) {
                $session_id = $header_arr['authtoken'];
            } else {
                $this->response([], 219);
            }
            $data = $this->_request1;
            if (!isset($data) || empty($data)) {

                $this->response([], 215);
            }
             $this->checkEmptyParameter($data, ["add","ooly_id","time"]);
            //Validate Data
            $this->db->beginTransaction();
            $isSessionExist = $this->Usermodel->getSessionRecord(["session_id" => $session_id]);
            if (false == $isSessionExist) {
                throw new Exception("Invalid Request || 219");
            }
            $user_id = $isSessionExist['user_id'];
            $isUserExist = $this->Usermodel->getRecordExists(["user_id" => $user_id]);
            if ($isUserExist['user_status'] == 2) {
                throw new Exception("Invalid User || 218");
            }
          
            $ooly_sync_record = $this->Usermodel->getRecords(["ooly_id" => $data["ooly_id"]], 'ai_ooly_schedule');
            
     
            
            if (false !== $ooly_sync_record && $ooly_sync_record['schedule_sync_time'] > $data['time']) {
        
                throw new Exception("Schedule Sync Expired || 223");
            }

            $device_id = $isSessionExist['device_id'];
           
            $this->db->executeTransaction();
            $schedule_sync_array = array();
       
            if (isset($data['add']) && !empty($data['add'])) {
                
                $newdata = array();
                
                foreach ($data['add'] as $key => $value) {
                    
                    $this->checkEmptyParameter($value, ["start_time", "color", "ooly_id", "repeat_day"]);
                    //Possible Array
                    $pArray = ["ooly_id", "device_id", "light_status", "start_time", "label", "color", "repeat_day", "manual_switch", "notification", "light_intensity_disable_blue", "light_intensity_color_transition", "light_intensity_transition_duration", "lantern_mode_status", "lantern_mode_color", "lantern_mode_disable_blue", "lantern_mode_color_transition", "lantern_mode_transition_duration", "lantern_mode_duration", "shake_mode", "max_uses", "user_id"];
                    $value = $this->defineSchedulesyncDefaultValue($pArray, $value);
                    $newdata[] = $value;
                }
                $this->db->beginTransaction();
                $condition = 'ooly_id = "' . $data["ooly_id"] . '"';
                $this->db->delete('ai_schedule_list', $condition);
                foreach ($newdata as $key => $value) {
                    $newdata[$key]['user_id'] = $user_id;
                    $newdata[$key]['device_id'] = $device_id;
                }
                $schedulelist = array("ooly_id", "device_id", "light_status", "start_time", "label", "color", "repeat_day", "manual_switch", "notification", "light_intensity_disable_blue", "light_intensity_color_transition", "light_intensity_transition_duration", "lantern_mode_status", "lantern_mode_color", "lantern_mode_disable_blue", "lantern_mode_color_transition", "lantern_mode_transition_duration", "lantern_mode_duration", "shake_mode", "max_uses", "user_id");
                $schedule_id = $this->db->bulkinsert('ai_schedule_list', $schedulelist, $newdata);
                
                if (false == $ooly_sync_record) {
                    $ooly_sync_data = ["ooly_id" => $data["ooly_id"], "schedule_sync_time" => $data["time"]];
                    $last_inserted_id = $this->db->insert("ai_ooly_schedule", $ooly_sync_data);
                } else {
                    $ooly_sync_data = ["schedule_sync_time" => $data["time"]];
                  $condition = 'ooly_id = "' . $data["ooly_id"] . '"';
                    $this->db->update("ai_ooly_schedule", $ooly_sync_data,$condition);
                }
                $this->db->executeTransaction();
              
            }
             $this->response([], 200, [], 'Success');
        } catch (Exception $ex) {
            $this->db->rollBack();
            $error = $ex->getMessage();
            list($msg, $code) = explode(" || ", $error);
            $this->response([], $code, [], $msg);
        }
    }

}
