<?php

namespace AppInventiv;

use AppInventiv\database\Db;
use AppInventiv\model\Usermodel;
use AppInventiv\Uploadexception;
use AppInventiv\SNSPush;
use AppInventiv\Rest;
use \Exception;

class Signup extends Rest {

    private $department;
    private $config;
    private $db;
    private $Usermodel;

    /**
     * @param $department
     * @param array $config
     */
    public function __construct() {
        parent::__construct();
        $this->db = new Db();
        $this->Usermodel = new Usermodel();
        $this->processApi();
    }

    private function processApi() {

        $func = strtolower(trim(str_replace("/", "", $_REQUEST['rquest'])));
        if ((int) method_exists($this, $func) > 0)
            $this->$func();
        else
            $this->response('', 404);    // If the method not exist with in this class, response would be "Page not found".
    }

    private function signup() {

        try {
            // Cross validation if the request method is POST else it will return "Not Acceptable" status
            if ($this->get_request_method() != "POST") {
                $this->response([], 405);
            }
            //Get all request Data
            $data = $this->_request;
            

            //Check requirement parameter missing
            //Total Input Array
            // Required Keys in array
            $this->checkEmptyParameter($data, ["email", "password"]);

            //Validate Data
            $this->validateData(["email" => $data["email"]]);

            //Possible Array
            $pArray = ["first_name", "middle_name", "timezone", "last_name", "email", "country", "state", "city", "gender", "biography", "dob", "age", "phone", "password", "username", "image", "device_id", "device_token", "ipaddress", "device_model", "imei", "os_version", "platform", "network", "app_version", "longitude", "latitude", "country_code", "region", "postal_code", "fb_id"];
            $data = $this->defineDefaultValue($pArray, $data);
            

            // if ($data["country_code"] == "") {
            //     $data = array_merge($data, (array) $this->getgeoip($_SERVER['REMOTE_ADDR']));
            // }

            $this->db->beginTransaction();
            $isUserExist = $this->Usermodel->getRecordExists(["email" => $data['email']]);

            if (false !== $isUserExist && $isUserExist['user_status']== 1) {
                throw new Exception("User already exists || 208");
            }
          

            /**
             * File Upload
             * ** */
            //echo getcwd()."/uploads/"; die;
            define("UPLOAD_DIR", getcwd() . "/uploads/");

            if (isset($_FILES['profile_image']) && !empty($_FILES['profile_image'])) {
                if ($_FILES['profile_image']['error'] === UPLOAD_ERR_OK) {

                    $format = array("IMAGETYPE_JPG", "3", "IMAGETYPE_JPEG", "2", "1", "IMAGETYPE_PNG");
                    if (!in_array(exif_imagetype($_FILES['profile_image']['tmp_name']), $format)) {
                        throw new Exception("Only Jpg, png file required || 216");
                    }
                    // echo "<pre>"; print_r($isUserExist); die;
                    //uploading successfully done 
                    // ensure a safe filename
                    //$name = preg_replace("/[^A-Z0-9._-]/i", "_", $_FILES["profile_image"]['name']);
                    $filename = explode(".", $_FILES["profile_image"]['name']);
                    $dot_count = count($filename);
                    $ext = $filename[$dot_count - 1];
                    $name = time() . "." . $ext;
                    // don't overwrite an existing file
                    // preserve file from temporary directory
                    $success = move_uploaded_file($_FILES["profile_image"]["tmp_name"], UPLOAD_DIR . $name);
                    if (!$success) {
                        throw new Exception("User profile image could not be save || 217");
                    }

                    // set proper permissions on the new file
                    chmod(UPLOAD_DIR . $name, 0644);
                } else {
                    throw new Uploadexception($_FILES['profile_image']['error']);
                }
            }

            $user = [

                "first_name" => $data["first_name"],
                "email" => $data["email"],
                "password" => $this->encrypt($data["password"]),
                "address" => $data['address'],
                "longitude" => $data['longitude'],
                "latitude" => $data['latitude'],
                "registered_date"=>date('Y/m/d'),
                //"image"=>$name,
                "status" => 1
            ];
            if (isset($name) && !empty($name)) {
                $user["image"] = $name;
            }
            if(false !== $isUserExist){
                $condition = 'user_id =' . $isUserExist['user_id'];
                $this->db->update('ai_user',$user,$condition);
                $user_id = $isUserExist['user_id'];
            }
            else{
            $user_id = $this->db->insert('ai_user', $user);
            }
            $access_token = $this->create_access_token($user_id, $data["email"]);
            list($private_key, $public_key) = explode("||", $access_token);
            $session = [
                "timezone" => $data["timezone"],
                "user_id" => $user_id,
                "device_id" => $data["device_id"],
                "device_token" => $data["device_token"],
                "ipaddress" => $data["ipaddress"],
                "device_model" => $data["device_model"],
                // "imei" => $data["imei"],
                "os_version" => $data["os_version"],
                "platform" => $data["platform"],
                //"network" => $data["network"],
                "app_version" => $data['app_version'],
                "login_time" => time(),
                // "country_code" => $data['country_code'],
                //"logout_time"=>
                "public_key" => $public_key,
                "private_key" => $private_key
            ];
            
            if ( !empty(trim($data["device_token"])) ) {   
                $sns = new SNSPush("arn:aws:sns:us-west-2:634381625056:firmware_update", "application");
                
                $response = $sns->addDeviceEndPoint(
                    trim($data["device_token"]),
                    strtolower($data["platform"]),
                    $session["user_id"]
                );
                if ( $response["success"] ) {
                    $session["device_arn"] = $response["result"]["EndpointArn"];
                }
                if ( $response["success"] &&
                   ( isset($dataexist["firmware_update"]) && (1 === (int)$dataexist["firmware_update"] ) )
                ) {
                    $resp = $sns->subscribeDevicetoTopic($response["result"]["EndpointArn"]);
    
                    if ( $resp["success"] ) {
                        $session["firmware_arn"] = $resp["result"]["SubscriptionArn"];
                    }
                }
                if ( $response["success"] &&
                 ( isset($dataexist["application_update"]) && (1 === (int)$dataexist["application_update"]) ) ) {
                    $appUpdate = new SNSPush("arn:aws:sns:us-west-2:634381625056:application_update", "application");
    
                    $resp = $sns->subscribeDevicetoTopic($response["result"]["EndpointArn"]);
                    if ( $resp["success"] ) {
                        $session["application_arn"] = $resp["result"]["SubscriptionArn"];
                    }
                }
            }
            $session_id = $this->db->insert('ai_session', $session);
            $arr = [

                "first_name" => $data["first_name"],
                "email" => $data["email"],
                "address"=> $data["address"],
                "public_key" => $public_key,
                "private_key" => $private_key,
                "session_id" => $session_id
            ];
            
            $this->db->executeTransaction();
        } catch (Exception $e) {
            $this->db->rollBack();
            $error = $e->getMessage();
            list($msg, $code) = explode(" || ", $error);
            $this->response([], $code, [], $msg);
        }
        // Success
        $this->response($arr, 200, [], 'Your registration process has been completed.');
    }

    /*
     * 	Encode array into JSON
     */

    private function json($data) {
        if (is_array($data)) {
            return json_encode($data);
        }
    }

}
