<?php

namespace AppInventiv;

use AppInventiv\database\Db;
use AppInventiv\model\Usermodel;
use AppInventiv\Rest;
use AppInventiv\SNSPush;
use \Exception;

class Sociallogin extends Rest {
    
    private $department;
    private $config;
    private $db;
    private $Usermodel;
    
    /**
     * @param $department
     * @param array $config
     */
    public function __construct() {
        parent::__construct();
        $this->db = new Db();
        $this->Usermodel = new Usermodel();
        $this->processApi();
    }
    
    private function processApi() {
        $func = strtolower(trim(str_replace("/", "", $_REQUEST['rquest'])));
        
        if ((int) method_exists($this, $func) > 0)
            $this->$func();
        else
            $this->response('', 404);    // If the method not exist with in this class, response would be "Page not found".
    }

    /**
     * @func: sociallogin
     * @params null
     * @throws Exception
     * @return  Response
     */
    private function sociallogin() {

        try {

            // Cross validation if the request method is POST else it will return "Not Acceptable" status
            if ($this->get_request_method() != "POST") {
                $this->response([], 405);
            }
            //Get all request Data
            $data = $this->_request;

            //echo "<pre>"; print_r($data); die;
            //Check requirement parameter missing
            //Total Input Array
            // Required Keys in array
            if (isset($_POST['fb_id'])) {
                $this->checkEmptyParameter($data, ["fb_id"]);
            } elseif (isset($_POST['google_id'])) {
                $this->checkEmptyParameter($data, [ "email", "google_id"]);
            } else {
                $this->checkEmptyParameter($data, ["email", "password"]);
            }


            //Validate Data
            if (isset($data["email"]) && !empty($data["email"])) {
                $this->validateData(["email" => $data["email"]]);
            }

            $pArray = ["first_name", "middle_name", "timezone", "last_name", "gender", "biography", "dob", "age", "phone", "email", "username", "image", "password", "device_id", "device_token", "ipaddress", "device_model", "imei", "os_version", "platform", "network", "app_version", "longitude", "latitude", "country_code", "region", "city", "postal_code", "fb_id", "google_id","address"
            ];

            $data = $this->defineDefaultValue($pArray, $data);

            $this->db->beginTransaction();

            if (isset($data['password']) && $data['password'] != "") {
                $isUserExist = $this->Usermodel->getRecordExists(["email" => $data['email']]);

                if (false == $isUserExist) {
                    throw new Exception("User does not exists || 210");
                }
                if ($isUserExist['user_status'] == 2) {
                    throw new Exception("Invalid User || 218");
                }

                $encrypt_pass = $this->encrypt($data["password"]);
                if ($isUserExist["password"] != $encrypt_pass) {
                    throw new Exception("Email or password is wrong. || 215");
                }
                $arr = $this->userlogin($data, $isUserExist);
            } elseif (isset($data['fb_id']) && $data['fb_id'] != "") {

                $isUserExist = $this->Usermodel->getRecordExists(["fb_id" => $data['fb_id']]);
                
             
                $userid = isset($userid) ? $userid : "";
                if (false == $isUserExist) {
                    if (empty($data['email']) || !isset($data['email'])) {
                        throw new Exception("Fb User is not registered. || 213");
                    }
                    $emailexist = $this->Usermodel->getRecordExists(["email" => $data['email']]);
                    
                    if (false !== $emailexist) {
                        // Check if user is active or deleted
                        if ($isUserExist['user_status'] == 2) {
                            throw new Exception("Invalid User || 218");
                        }
                        $user_id = $emailexist['user_id'];
                        $user = [ "fb_id" => $data["fb_id"]];
                        $condition = 'user_id =' . $user_id;
                         $query_run = $this->db->update('ai_user', $user, $condition);
                      
                        if ($query_run) {
                            $arr = $this->userlogin($data, $emailexist, $userid);
                        }
                    }
                     else {
                        $arr = $this->usersignup($data);
                    }
                } 
            else {

                    // Check if user is active or deleted
                    if ($isUserExist['user_status'] == 2) {
                        throw new Exception("Invalid User || 218");
                    }
                    if(!empty($data['email'])){
                         $emailexist = $this->Usermodel->getRecordExists(["email" => $data['email']]);

                         if (false == $emailexist) {
                             $condition = 'fb_id =' . $data['fb_id'];
                          $a =   $this->db->update('ai_user', array('email'=>$data['email']), $condition);
                         
                         }

                    }
                    $arr = $this->userlogin($data, $isUserExist, $userid);
                }
            
            } elseif (isset($data['google_id']) && $data['google_id'] != "") {
                $isUserExist = $this->Usermodel->getRecordExists(["google_id" => $data['google_id']]);
                $userid = isset($userid) ? $userid : "";
                if (false == $isUserExist) {
                    $emailexist = $this->Usermodel->getRecordExists(["email" => $data['email']]);
                    if (false !== $emailexist) {
                        // Check if user is active or deleted
                        if ($isUserExist['user_status'] == 2) {
                            throw new Exception("Invalid User || 218");
                        }
                        $user_id = $emailexist['user_id'];
                        $user = [ "google_id" => $data["google_id"]];
                        $condition = 'user_id =' . $user_id;
                        $query_run = $this->db->update('ai_user', $user, $condition);
                        if ($query_run) {
                            $arr = $this->userlogin($data, $emailexist, $userid);
                        }
                    } else {
                        $arr = $this->usersignup($data);
                    }
                } else {
                    // Check if user is active or deleted
                    if ($isUserExist['user_status'] == 2) {
                        throw new Exception("Invalid User || 218");
                    }
                    $arr = $this->userlogin($data, $isUserExist, $userid);
                }
            }
        } catch (Exception $e) {

            $this->db->rollBack();
            $error = $e->getMessage();
            
            list($msg, $code) = explode(" || ", $error);
          
            $this->response([], $code, [], $msg);
            
        }
        // Success

        $this->response($arr, 200, [], 'You have logged in successfully.');
    }

    /**
     * @func: userlogin
     * @params request data, user data(If exist), user id(after signup)
     * @throws Exception
     * @return  User Info 
     */
    function userlogin($data, $isUserExist, $userid = '') {
        
        $user_id = isset($isUserExist['user_id']) ? $isUserExist['user_id'] : $userid;
        $email = $isUserExist['email'];
        $user = [
            "login_time" => time()
        ];
        $condition = 'user_id =' . $user_id;
        $this->db->update('ai_user', $user, $condition);
        $dataexist = $this->Usermodel->getRecordExists(["user_id" => $user_id]);
        $deviceexist = $this->Usermodel->getRecords(["user_id"=>$user_id,"device_id"=>$data["device_id"]],'ai_session');

        
        $access_token = $this->create_access_token($user_id, $email);
        list($private_key, $public_key) = explode("||", $access_token);
        $session = [
            "timezone" => $data["timezone"],
            "user_id" => $user_id,
            "device_id" => $data["device_id"],
            "device_token" => $data["device_token"],
            "ipaddress" => $data["ipaddress"],
            "device_model" => $data["device_model"],
            "imei" => $data["imei"],
            "os_version" => $data["os_version"],
            "platform" => $data["platform"],
            "network" => $data["network"],
            "app_version" => $data['app_version'],
            "firmware_update"=>$isUserExist["firmware_update"],
            "application_update" =>$isUserExist["application_update"],
            "light_period_start" => $isUserExist["light_period_start"],
            "login_time" => time(),
            //"country_code" => $data['country_code'],
            "public_key" => $public_key,
            "private_key" => $private_key
        ];

        if ( !empty(trim($data["device_token"])) ) {   
            $sns = new SNSPush("arn:aws:sns:us-west-2:634381625056:firmware_update", "application");
            
            $response = $sns->addDeviceEndPoint(
                trim($data["device_token"]),
                strtolower($data["platform"]),
                $session["user_id"]
            );
            if ( $response["success"] ) {
                $session["device_arn"] = $response["result"]["EndpointArn"];
            }
            if ( $response["success"] &&
               ( isset($dataexist["firmware_update"]) && (1 === (int)$dataexist["firmware_update"] ) )
            ) {
                $resp = $sns->subscribeDevicetoTopic($response["result"]["EndpointArn"]);

                if ( $resp["success"] ) {
                    $session["firmware_arn"] = $resp["result"]["SubscriptionArn"];
                }
            }
            if ( $response["success"] &&
             ( isset($dataexist["application_update"]) && (1 === (int)$dataexist["application_update"]) ) ) {
                $appUpdate = new SNSPush("arn:aws:sns:us-west-2:634381625056:application_update", "application");

                $resp = $appUpdate->subscribeDevicetoTopic($response["result"]["EndpointArn"]);
                if ( $resp["success"] ) {
                    $session["application_arn"] = $resp["result"]["SubscriptionArn"];
                }
            }
        }
        
        $session_id = $this->db->insert('ai_session', $session);

        $arr = [
            "first_name" => $dataexist["first_name"],
            "email" => $dataexist["email"],
            "image" => isset($dataexist["image"]) && !empty($dataexist["image"]) ? "http://" . $_SERVER['SERVER_NAME'] . '/admin/public/uploads/userimages/' . $dataexist["image"] : "",
            "firmware_update"=> $dataexist["firmware_update"],
            "application_update" =>$dataexist["application_update"],
            "light_period_start" => $dataexist["light_period_start"],
            "public_key" => $public_key,
            "private_key" => $private_key,
            "session_id" => $session_id
        ];
       

        //echo "<pre>"; print_r($isUserExist); die;

        $this->db->executeTransaction();
        return $arr;
    }

    /**
     * @func: usersignup
     * @params request data
     * @return  user_id to login function
     */
    function usersignup($data) {

        define("UPLOAD_DIR", getcwd() . "/uploads/");

        if (isset($_FILES['profile_image']) && !empty($_FILES['profile_image'])) {
            if ($_FILES['profile_image']['error'] === UPLOAD_ERR_OK) {

                $format = array("IMAGETYPE_JPG", "3", "IMAGETYPE_JPEG", "2", "1", "IMAGETYPE_PNG");
                if (!in_array(exif_imagetype($_FILES['profile_image']['tmp_name']), $format)) {
                    throw new Exception("Only Jpg, png file required || 216");
                }
                // echo "<pre>"; print_r($isUserExist); die;
                //uploading successfully done 
                // ensure a safe filename
                //$name = preg_replace("/[^A-Z0-9._-]/i", "_", $_FILES["profile_image"]['name']);
                $filename = explode(".", $_FILES["profile_image"]['name']);
                $dot_count = count($filename);
                $ext = $filename[$dot_count - 1];
                $name = time() . "." . $ext;
                // don't overwrite an existing file
                // preserve file from temporary directory
                $success = move_uploaded_file($_FILES["profile_image"]["tmp_name"], UPLOAD_DIR . $name);
                if (!$success) {
                    throw new \Exception("User profile image could not be save || 217");
                }

                // set proper permissions on the new file
                chmod(UPLOAD_DIR . $name, 0644);
            } else {
                throw new Uploadexception($_FILES['profile_image']['error']);
            }
        }

        $user = [

            "first_name" => $data["first_name"],
            "middle_name" => $data["last_name"],
            "last_name" => $data["last_name"],
            "email" => $data["email"],
            "gender" => $data["gender"],
            "biography" => $data["biography"],
            "dob" => $data["dob"],
            "age" => $data["age"],
            "phone" => $data["phone"],
            "country_code" => $data['country_code'],
            "fb_id" => $data['fb_id'],
            "google_id" => $data['google_id'],
            "username" => $data['username'],
            "city" => $data['city'],
            "state" => $data['state'],
            "country" => $data['country'],
            "address" => $data['address'],
            "firmware_update"=> 1,
            "application_update" =>1,
            "light_period_start" => 1,
            "postal_code" => $data['postal_code'],
            "longitude" => $data['longitude'],
            "latitude" => $data['latitude'],
            "login_time" => time(),
            "registered_date"=>date('Y/m/d'),
            //"image"=>$name,
            "status" => 1
        ];

       
        if (isset($name) && !empty($name)) {
            $user["image"] = $name;
        }

        $user_id = $this->db->insert('ai_user', $user);
        //    echo $user_id;die;
        $access_token = $this->create_access_token($user_id, $data["email"]);
        list($private_key, $public_key) = explode("||", $access_token);
        $session = [
            "timezone" => $data["timezone"],
            "user_id" => $user_id,
            "device_id" => $data["device_id"],
            "device_token" => $data["device_token"],
            "ipaddress" => $data["ipaddress"],
            "device_model" => $data["device_model"],
            "imei" => $data["imei"],
            "os_version" => $data["os_version"],
            "platform" => $data["platform"],
            "network" => $data["network"],
            "app_version" => $data['app_version'],
            "login_time" => time(),
            "country_code" => $data['country_code'],
            "firmware_update"=> 1,
            "application_update" =>1,
            "light_period_start" => 1,
            //"logout_time"=>
            "public_key" => $public_key,
            "private_key" => $private_key
        ];
        
        if ( !empty(trim($data["device_token"])) ) {   
            $sns = new SNSPush("arn:aws:sns:us-west-2:634381625056:firmware_update", "application");
            
            $response = $sns->addDeviceEndPoint(
                trim($data["device_token"]),
                strtolower($data["platform"]),
                $session["user_id"]
            );
            if ( $response["success"] ) {
                $session["device_arn"] = $response["result"]["EndpointArn"];
            }
            if ( $response["success"] &&
               ( isset($dataexist["firmware_update"]) && (1 === (int)$dataexist["firmware_update"] ) )
            ) {
                $resp = $sns->subscribeDevicetoTopic($response["result"]["EndpointArn"]);

                if ( $resp["success"] ) {
                    $session["firmware_arn"] = $resp["result"]["SubscriptionArn"];
                }
            }
            if ( $response["success"] &&
             ( isset($dataexist["application_update"]) && (1 === (int)$dataexist["application_update"]) ) ) {
                $appUpdate = new SNSPush("arn:aws:sns:us-west-2:634381625056:application_update", "application");

                $resp = $appUpdate->subscribeDevicetoTopic($response["result"]["EndpointArn"]);
                if ( $resp["success"] ) {
                    $session["application_arn"] = $resp["result"]["SubscriptionArn"];
                }
            }
        }

        $session_id = $this->db->insert('ai_session', $session);
        

        $arr = [

            "first_name" => $data["first_name"],
            "email" => $data["email"],
            "firmware_update"=> 1,
            "application_update" =>1,
            "light_period_start" => 1,
            "public_key" => $public_key,
            "private_key" => $private_key,
            "session_id" => $session_id
        ];

        $this->db->executeTransaction();
        return $arr;
    }

    /*
     * 	Encode array into JSON
     */

    private function json($data) {
        if (is_array($data)) {
            return json_encode($data);
        }
    }

}
