<?php

//$fileurl = $_SERVER['DOCUMENT_ROOT'].'/ooly/webservices/lib/Appinventiv/PHPMailer/PHPMailerAutoload.php';
//die;

namespace AppInventiv;

use AppInventiv\database\Db;
use AppInventiv\model\Usermodel;
use AppInventiv\Rest;
use \Exception;

//use \PHPMailer\PHPMailerAutoload;

class Verifyotp extends Rest {

    private $config;
    private $db;
    private $Usermodel;
    private $mail;

    public function __construct() {
        parent::__construct();

        $this->db = new Db();
        $this->Usermodel = new Usermodel();
        $this->processApi();
    }

    private function processApi() {

        $func = strtolower(trim(str_replace("/", "", $_REQUEST['rquest'])));

        if ((int) method_exists($this, $func) > 0)
            $this->$func();
        else
            $this->response('', 404);    // If the method not exist with in this class, response would be "Page not found".
    }

    private function verifyotp() {

        try {
            if ($this->get_request_method() != "POST") {
                $this->response([], 405);
            }
            //Get all request Data
            $data = $this->_request;





            $this->checkEmptyParameter($data, ["email","OTP"]);
            //Validate Data
            $this->validateData(["email" => $data["email"]]);

            $this->db->beginTransaction();
            $isUserExist = $this->Usermodel->getRecordExists(["email" => $data['email']]);

            if (false === $isUserExist) {
                throw new Exception("User does not exists || 210");
            }

            $email = $isUserExist['email'];
            $otp = strtolower($isUserExist['OTP']);
            $otp_save_time = $isUserExist['OTP_TIME'];
            $current_time = time();
            $time_span = $current_time - $otp_save_time;
            $time_lag = $time_span / 60;
         
            if ($time_lag > 5) {

                throw new Exception("Temporary Password is expired. || 211");
            }

            if ($otp !== strtolower($data['OTP'])) {

                throw new Exception("Temporary Password is wrong. || 212");
            }
            $user_id = $isUserExist['user_id'];
     
            $user = [
                "is_verified" => 1
            ];
            $condition = 'user_id =' . $user_id;
            $this->db->update('ai_user', $user, $condition);
            $this->db->executeTransaction();
        } catch (Exception $ex) {
            $this->db->rollBack();
            $error = $ex->getMessage();
            list($msg, $code) = explode(" || ", $error);
            $this->response([], $code, [], $msg);
        }
        $response_data['user_id'] = $user_id;
        $this->response($response_data, 200, [], "Success");
    }

}
