<?php

namespace AppInventiv;

use AppInventiv\database\Db;
use AppInventiv\model\Usermodel;
use AppInventiv\Rest;
use \Exception;

class Forgotpassword extends Rest {

    private $department;
    private $config;
    private $db;
    private $Usermodel;
    private $mail;

    public function __construct() {
        parent::__construct();

        $this->db = new Db();
        $this->Usermodel = new Usermodel();
        $this->processApi();
    }

    private function processApi() {

        $func = strtolower(trim(str_replace("/", "", $_REQUEST['rquest'])));

        if ((int) method_exists($this, $func) > 0)
            $this->$func();
        else
            $this->response('', 404);    // If the method not exist with in this class, response would be "Page not found".
    }

    private function forgotpassword() {
        try {
            if ($this->get_request_method() != "POST") {
                $this->response([], 405);
            }
            //Get all request Data
            $data = $this->_request;
            // Get api request Data
            $req_data = $this->_apirequestarray;
            $api_array = array('function'=>forgotpassword,'data'=>$req_data);
           
            $this->checkEmptyParameter($data, ["email"]);
            //Validate Data
            $this->validateData(["email" => $data["email"]]);

            $this->db->beginTransaction();
             $this->db->checkApiparameter($api_array,'ai_dummy');
            $isUserExist = $this->Usermodel->getRecordExists(["email" => $data['email']]);

            if (false === $isUserExist) {

                throw new Exception("User does not exists || 210 || ");
            }
            $user_id = $isUserExist['user_id'];
            $user_name = isset($isUserExist['first_name']) ? $isUserExist['first_name'] : "User";
            $email = $isUserExist['email'];
            $subject = "Password Reset";
            //$this->mail();
            $otp_code = strtoupper(bin2hex(openssl_random_pseudo_bytes(3)));
            $message = "Hi" . $user_name . ",A request was made recently to reset your password for Ooly account. Your temporary password is " . $otp_code . "If you did not ask for your password to be reset, ignore this mail.Best Regards,Ooly Team";
            ooly_mail($email, $message, $subject);

//            $mail = new PHPMailer/PHPMailerAutoload;
//            var_dump($mail); die;
//            $smtp_mail = new Commonmailfunction();
//            $smtp_mail->ooly_mail($email);
            $user = [
                "OTP" => $otp_code,
                "OTP_TIME" => time()
            ];
            $condition = 'user_id =' . $user_id;
            $this->db->update('ai_user', $user, $condition);
            $this->db->executeTransaction();
        } catch (Exception $ex) {
            $this->db->rollBack();
            $error = $ex->getMessage();
            list($msg, $code) = explode(" || ", $error);
            $this->response([], $code, [], $msg);
        }
        $response_data['OTP'] = $otp_code;
        $this->response($response_data, 200, [], "Message has been sent successfully");
    }

}
