
<?php

class Tm_department extends CI_Model {

    public function __construct() {
        $this->load->database();
        $this->table_name = 'tm_department';
    }

    public function insert($insArr = array()) {
        if (isset($insArr) && is_array($insArr) && count($insArr)) {
            try {
                $this->db->insert($this->table_name, $insArr);
                return $this->db->insert_id();
            } catch (\Exception $err) {
                
            }
        }
    }

    public function update($updArr = array(), $condArr = array()) {
        if (isset($updArr) && is_array($updArr) && count($updArr) && isset($condArr) && is_array($condArr) && count($condArr)) {
            try {
                $this->db->update($this->table_name, $updArr, $condArr);
                return 1;
            } catch (\Exception $err) {
                
            }
        }
    }

    public function findOne($condArr = array()) {
        $returnObj = new stdClass();
        if (isset($condArr) && is_array($condArr) && count($condArr)) {
            try {
                $this->db->where($condArr);
            } catch (\Exception $err) {
                
            }
        }
        $query = $this->db->get($this->table_name);
        $returnObj = $query->row();
        return $returnObj;
    }

    public function findAll($condArr = array()) {
        if (isset($condArr) && is_array($condArr) && count($condArr)) {
            $this->db->where($condArr);
        }
        $query = $this->db->get($this->table_name);
        $returnObj = $query->result_array();
        return $returnObj;
    }

    /*
     * find with or condition
     */

    public function findOneMultiCond($condArr = array(), $email) {
        $returnObj = new stdClass();
        if (isset($condArr) && is_array($condArr) && count($condArr)) {
            try {
                $this->db->where($condArr);
                if (isset($email) && !empty($email)) {
                    $this->db->or_where('email', $email);
                }
            } catch (\Exception $err) {
                
            }
        }
        $query = $this->db->get($this->table_name);
        $returnObj = $query->result_array();
        return $returnObj;
    }

    /*
     * Function for get only language by user_id
     */

    public function getUserLanguage($user_id = 0) {
        if ($user_id > 0) {
            $this->db->column(array('u_language'));
            $query = $this->db->get_where($this->table_name, array('user_id' => $user_id));
            $returnObj = $query->row();
            return $returnObj;
        }
    }

    /*
     * function to get total table count
     */

    public function totalDepartmentCount() {
        try {
            $this->db->select("COUNT(*) as rows");
            $query = $this->db->from($this->table_name);
        } catch (\Exception $err) { /*         * * Do Nothing */
        }
        $query = $this->db->get();
        return $query->row();
    }

    /*
     * Fetch Department Data as per the condition & limits
     */

    public function fetch_admin_department_list($limit = false, $start = false, $condition = array()) {
        try {
//            $this->db->select('count(tdd.id) as dept_count,tm_department.*');
//            $this->db->from($this->table_name);
//            $this->db->join('tm_doctor_department tdd', 'tm_department.dept_id=tdd.dept_id','LEFT');
            $this->db->from($this->table_name);
            $this->db->where('tm_department.status !=', 3);
            if (!empty($condition)) {

                if (isset($condition['dept_name']) && isset($condition['status'])) {
                    $this->db->where(array('dept_name ' => $condition['dept_name'], 'status ' => $condition['status']));
                } else if (isset($condition['dept_name']) && !isset($condition['status'])) {

                    $this->db->where('dept_name', $condition['dept_name']);
                } elseif (!isset($condition['dept_name']) && isset($condition['status'])) {

                    $this->db->where('status', $condition['status']);
                }
                if (isset($condition['department_name']) && $condition['department_name'] != '') {
                    //$this->db->replace($this->table.'pharmacy_name',' ','');
                    $this->db->like('dept_name', $condition['department_name'], 'after');
                   
                    $this->db->or_like('dept_name', " ".$condition['department_name']);
                }
            }
              if (isset($condition['sort_by']) && isset($condition['sort_order'])){
                  $sort_by =  $condition['sort_by'];
                  $sort_order = $condition['sort_order'];
              }
              else{
                     $sort_by = "dept_name";
                     $sort_order = "ASC";
              }
            $this->db->group_by('tm_department.dept_id');
            $this->db->order_by('tm_department.'.$sort_by,  $sort_order);
            if ($limit) {
                $this->db->limit($limit, $start);
            }
        } catch (Exception $e) {
            
        }
        $query = $this->db->get();

        //echo $this->db->last_query();die;
        $result = $query->result_array();

        if (count($result) > 0) {
            return $result;
        } else {
            return array();
        }
    }

    /*
     * Add New Department
     */

    public function create_department($department_name, $department_status, $department_hod) {

        $data = array('dept_name' => $department_name, 'dept_head' => $department_hod, 'status' => $department_status);
        $query = $this->db->insert('tm_department', $data);
        return $query;
    }

    /*     * **
     * Get Department By Id
     */

    public function get_department($depatment_id) {
        $this->db->select('*');
        $this->db->from('tm_department');
        $this->db->where('dept_id =', $depatment_id);
        $this->db->limit(1);
        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            $ret = $query->row();
            return $ret;
        } else {
            return false;
        }
    }

    /*     * **
     * Edit Department 
     * 
     */

    public function edit_department($department_name, $department_status, $department_hod, $department_id) {
        $data = array('dept_name' => $department_name, 'dept_head' => $department_hod, 'status' => $department_status);
        $query = $this->db->insert('tm_department', $data);
        return $query;
    }

    /*
     * Fetch Department Data as per the condition & limits
     */

    public function fetch_only_dpmt_name() {
        try {
            $this->db->select('dept_name');
            $this->db->from($this->table_name);

            $this->db->group_by('dept_name');
        } catch (Exception $e) {
            
        }
        $query = $this->db->get();
        //echo $this->db->last_query();die;
        $result = $query->result_array();
        if (count($result) > 0) {
            return $result;
        } else {
            return array();
        }
    }

}

//end of class here
