<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * @author     pramod jaiswal
 * @date       22-02-2017
 * @controller Ajax 
 */
class Ajax extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->helper('url');
        $this->load->helper('email');
        $this->load->helper('cookie');
        $this->load->model('Common_model');
        $this->load->model('Tm_patient_model');
        $this->load->model('Tm_department');
        $this->load->library('session');
        $language = $this->session->userdata('language');
        $this->load->language('web', $language);
        $this->datetime = date('Y-m-d H:i:s');
        if (!$this->input->is_ajax_request()) {exit('No direct script access allowed');}
    }

    /**
     * changeAllStatus function     
     * @access	public
     * @description its working for chenge status of user doctor hospital and so on 
     * @date 22/02/2017
     */
    
    public function changestatusallinone() {
        $post = $this->input->post();
        if (($post['newstatus'] == '2' or ($post['newstatus'] == '1')) and $post['for'] == 'doctor') {
            //update patient data
            $user_status = array('u_status' => $post['newstatus']);
            $res = $this->Common_model->update_single('tm_user', $user_status, array('where' => array('user_id' => $post['id'])), true);
            $obj['ercode'] = '200';
            $obj['ermsg'] = 'Doctor Blocked Succssfully';
            echo json_encode($obj); die;
            
        } elseif ($post['for'] == 'doctor' and $post['newstatus'] == 3) {
            //update patient data
            $user_status = array('u_status' => $post['newstatus']);
            $res = $this->Common_model->update_single('tm_user', $user_status, array('where' => array('user_id' => $post['id'])), true);
            $obj['ercode'] = '200';
            $obj['ermsg'] = 'Doctor Delete Succssfully';
            echo json_encode($obj); die;
        }elseif ($post['for'] == 'user' and ($post['newstatus'] == '2' or ($post['newstatus'] == '1'))) {
            //update doctor data
            $user_status = array('u_status' => $post['newstatus']);
            $res = $this->Common_model->update_single('tm_user', $user_status, array('where' => array('user_id' => $post['id'])), true);
            $obj['ercode'] = '200';
            $obj['ermsg'] = 'Doctor Block Succssfully';
            echo json_encode($obj); die;
        }elseif ($post['for'] == 'user' and $post['newstatus'] == 3) {
            //update doctor data
            $user_status = array('u_status' => $post['newstatus']);
            $res = $this->Common_model->update_single('tm_user', $user_status, array('where' => array('user_id' => $post['id'])), true);
            $obj['ercode'] = '200';
            $obj['ermsg'] = 'Doctor Delete Succssfully';
            echo json_encode($obj); die;
        } elseif ($post['for'] == 'appoinment' and $post['newstatus'] == 5) {
            $data = array('status' => '5');
            $res = $this->Common_model->update_single('tm_appointment', $data, array('where' => array('from_id' => $post['id'])), true);
        } elseif ($post['for'] == 'department' and $post['newstatus'] == 3) {
            //update patient data
            $dep_status = array('status' => $post['newstatus']);
            $res = $this->Common_model->update_single('tm_department', $dep_status, array('where' => array('dept_id' => $post['id'])), true);
            $obj['ercode'] = '200';
            $obj['ermsg'] = 'Department Delete Succssfully';
            echo json_encode($obj); die;
        }elseif ($post['for'] == 'department' and $post['newstatus'] == 2) {
            //update patient data
            $dep_status = array('status' => $post['newstatus']);
            $res = $this->Common_model->update_single('tm_department', $dep_status, array('where' => array('dept_id' => $post['id'])), true);
            $obj['ercode'] = '200';
            $obj['ermsg'] = 'Department Blocked Succssfully';
            echo json_encode($obj); die;
        }
        elseif ($post['for'] == 'department' and $post['newstatus'] == 1) {
            //update patient data
            $dep_status = array('status' => $post['newstatus']);
            $res = $this->Common_model->update_single('tm_department', $dep_status, array('where' => array('dept_id' => $post['id'])), true);
            $obj['ercode'] = '200';
            $obj['ermsg'] = 'Department Unblocked Succssfully';
            echo json_encode($obj); die;
        }
         elseif ($post['for'] == 'hospital' and $post['newstatus'] == 3) {
            //update patient data
            $hospital_status = array('hospital_status' => $post['newstatus']);
            $res = $this->Common_model->update_single('tm_hospital', $hospital_status, array('where' => array('hospital_id' => $post['id'])), true);
            $obj['ercode'] = '200';
            $obj['ermsg'] = 'Hospital Delete Succssfully';
            echo json_encode($obj); die;
        }elseif ($post['for'] == 'hospital' and $post['newstatus'] == 2) {
            //update patient data
            $hospital_status = array('hospital_status' => $post['newstatus']);
            $res = $this->Common_model->update_single('tm_hospital', $hospital_status, array('where' => array('hospital_id' => $post['id'])), true);
            $obj['ercode'] = '200';
            $obj['ermsg'] = 'Hospital Blocked Succssfully';
            echo json_encode($obj); die;
        }
        elseif ($post['for'] == 'hospital' and $post['newstatus'] == 1) {
            //update patient data
            $hospital_status = array('hospital_status' => $post['newstatus']);
            $res = $this->Common_model->update_single('tm_hospital', $hospital_status, array('where' => array('hospital_id' => $post['id'])), true);
            $obj['ercode'] = '200';
            $obj['ermsg'] = 'Hospital Unblocked Succssfully';
            echo json_encode($obj); die;
        }
        else {
             $obj['ermsg'] = 'No Action Perform';
            echo json_encode($obj); die;
        }

        die;
    }
    //Add Departments
   public function addDepartments(){
     
       $query = $this->Tm_department->create_department($this->input->post('department_name'), $this->input->post('department_status'), $this->input->post('department_hod'));
       if($query){
           $result= array("status"=>1,"message"=>"Department Successfully Added");
       }
       else{
           $result = array("status"=>0,"message"=>"Error in Adding Department");
       }
        echo  json_encode($result);
   }
   // Get Departments By ID
   public function getDepartmentsbyId(){
       $query= $this->Tm_department->get_department($this->input->get('id')) ;
      echo  json_encode($query);
   }
   // Edit Departments
   public function editDepartments(){
//       $this->form_validation->set_rules('dept_name', 'Department Name', 'trim|required');
       $data = array('dept_name'=> $this->input->post('dept_name'), 'dept_head'=>$this->input->post('edit_department_head'),'status'=> $this->input->post('edit_status'));
       $condition['dept_id'] =  $this->input->post('department_id');
       $query=$this->Tm_department->update($data,$condition);
       
        if($query){
           $result= array("status"=>400,"message"=>"Department Successfully Edit");
       }
       else{
           $result = array("status"=>0,"message"=>"Error in Editing Department");
       }
       echo json_encode($result);
   }
}
