<?php

class Hospital extends MX_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Common_model');
        $this->load->model('Tm_hospital');
        $this->load->helper('url');
        $this->load->library('session');
        $language = $this->session->userdata('language');
        $this->load->language('web', $language);
        $this->datetime = date('Y-m-d H:i:s');
        $this->load->library('pagination');
        // Load form helper library
        $this->load->helper('form');
    }

    public function index() {
        $data = array();
        $params = array();
        $getrequest = $this->input->get();

        if (isset($getrequest['hospital_filter'])) {
            $hospital_name = isset($getrequest['hospital_name']) ? trim($getrequest['hospital_name']) : "";
            $hospital_status = isset($getrequest['hospital_status']) ? (int) $getrequest['hospital_status'] : "";
            if ($hospital_name !== "") {
                $params['dept_name'] = $hospital_name;
            }
            if ($hospital_status !== 0) {
                $params['status'] = $hospital_status;
            }
        }
      



        //calling pagination helper
        $getrequest = $this->input->get();
        $page = isset($getrequest['page']) ? $getrequest['page'] : 1;
        $pagecount = isset($getrequest['pagecount']) ? $getrequest['pagecount'] : 10;
        $limit = $pagecount;
        $rowcount = $this->Tm_hospital->totalHospitalCount();
        $this->load->helper('pagination_helper');
        $config = get_pagination_config();
        $config['base_url'] = base_url() . 'Admin/hospital';
        $config['total_rows'] = !empty($rowcount) ? $rowcount->rows : 0;
        $config["per_page"] = $limit;

        $this->pagination->initialize($config);
          // Search by Hospital Name
        if (isset($getrequest['search']) && $getrequest['search'] != '') {
            $params['hospital_name'] = trim($getrequest['search']);
            isset($getrequest['hospital_name']) ? trim($getrequest['hospital_name']) : "";
        } 
        //  Sort By Specific Field
           if(isset($getrequest['action']) && $getrequest['action']=='sorting'){
              $params['sort_by']=$getrequest['name'];
              $params['sort_order']=$getrequest['sort_order'];
           
              
          }
        $page = isset($page) ? $page : 1;
        $hospital = $data['hospital_list'] = $this->Tm_hospital->fetch_admin_hospital_list($limit, $offset = ($page - 1) * $limit, $params);
        $data["links"] = $this->pagination->create_links();


        $this->Common_model->load_views('hospitals/index', $data);
    }

}

?>
