
<?php

class Tm_hospital extends CI_Model {

    public function __construct() {
        $this->load->database();
        $this->table_name = 'tm_hospital';
    }

    public function insert($insArr = array()) {
        if (isset($insArr) && is_array($insArr) && count($insArr)) {
            try {
                $this->db->insert($this->table_name, $insArr);
                return $this->db->insert_id();
            } catch (\Exception $err) {
                
            }
        }
    }

    public function update($updArr = array(), $condArr = array()) {
        if (isset($updArr) && is_array($updArr) && count($updArr) && isset($condArr) && is_array($condArr) && count($condArr)) {
            try {
                $this->db->update($this->table_name, $updArr, $condArr);
                return 1;
            } catch (\Exception $err) {
                
            }
        }
    }

    public function findOne($condArr = array()) {
        $returnObj = new stdClass();
        if (isset($condArr) && is_array($condArr) && count($condArr)) {
            try {
                $this->db->where($condArr);
            } catch (\Exception $err) {
                
            }
        }
        $query = $this->db->get($this->table_name);
        $returnObj = $query->row();
        return $returnObj;
    }

    public function findAll($condArr = array()) {
        if (isset($condArr) && is_array($condArr) && count($condArr)) {
            $this->db->where($condArr);
        }
        $query = $this->db->get($this->table_name);
        $returnObj = $query->result_array();
        return $returnObj;
    }

    /*
     * Function for fetch hospitals details
     */

    public function findAllHospitals($condArr = array()) {
        try {
            $query = $this->db->from($this->table_name);
            $this->db->join('tm_hospital_department AS thd', 'thd.hospital_id = tm_hospital.hospital_id', 'LEFT');
            $this->db->join('tm_hospital_services AS ths', 'ths.hospital_id = tm_hospital.hospital_id', 'LEFT');
            //$this->db->join('tm_like AS tlike', 'tlike.liking_id = tm_hospital.hospital_id and tlike.user_id = '.$condArr['user_id'].' and tlike.liking_type = 1 and tlike.status=1', 'LEFT');
            $this->db->join('tm_rating AS rat', 'rat.product_rating_id = tm_hospital.hospital_id and rat.product_type = 1 and rat.status=1', 'LEFT');

            if (isset($condArr) && is_array($condArr) && count($condArr)) {
                /*                 * ********* Apply LAT & LONG   *********** */
                if (isset($condArr['u_lat']) && !empty($condArr['u_lat']) && isset($condArr['u_long']) && !empty($condArr['u_long'])) {
                    $this->db->select("tm_hospital.*, ( 3959 * acos( cos( radians(" . $condArr['u_lat'] . ") ) * cos( radians( tm_hospital.hospital_latitude ) )* cos( radians( tm_hospital.hospital_longitude ) - radians(" . $condArr['u_long'] . ") ) + sin( radians(" . $condArr['u_lat'] . ") ) * sin(radians(tm_hospital.hospital_latitude)) ) ) AS distance, AVG(rat.rating) as hospital_rating");
                    if (isset($condArr['radius']) && !empty($condArr['radius'])) {
                        $this->db->having('distance < ' . $condArr['radius']); // 100 miled default
                    } else {
                        $this->db->having('distance < 101'); // 100 miled default
                    }
                    $this->db->group_by('tm_hospital.hospital_id');
                }
                /*                 * ********* Apply service_id filter   *********** */
                if (isset($condArr['service_id']) && !empty($condArr['service_id'])) {
                    $this->db->where_in('ths.service_id', $condArr['service_id']);
                }
                /*                 * ********* Apply dept_id filter   *********** */
                if (isset($condArr['dept_id']) && !empty($condArr['dept_id'])) {
                    $this->db->where_in('thd.dept_id', $condArr['dept_id']);
                }
                /*                 * ********* Apply search by hospital name filter   *********** */
                if (isset($condArr['search']) && !empty($condArr['search'])) {
                    $this->db->where('tm_hospital.hospital_name like "%' . $condArr['search'] . '%" ');
                }
                if (isset($condArr['page'])) {
                    if ($condArr['page'] == 0) {
                        $this->db->limit(10, $condArr['page']);
                    } else {
                        $this->db->limit(10, $condArr['page'] * 10);
                    }
                }
                if (isset($condArr['sort']) && !empty($condArr['sort'])) {
                    $expSortArr = explode(',', $condArr['sort']);
                    if (isset($expSortArr) && is_array($expSortArr) && count($expSortArr)) {
                        $this->db->order_by($expSortArr[0], $expSortArr[1]);
                    }
                }
            }
        } catch (\Exception $err) { /*         * * Do Nothing */
        }
        $query = $this->db->get();
        //echo $this->db->last_query();die;
        $returnArr = $query->result_array();
        return $returnArr;
    }

    public function findHospitalDetails($condArr = array()) {
        try {
            $query = $this->db->from($this->table_name);
            $this->db->join('tm_like AS tlike', 'tlike.liking_id = tm_hospital.hospital_id and tlike.liking_type = 1 and tlike.status=1', 'LEFT');
            $this->db->join('tm_rating AS rat', 'rat.product_rating_id = tm_hospital.hospital_id and rat.product_type = 1 and rat.status=1', 'LEFT');
            if (isset($condArr) && is_array($condArr) && count($condArr)) {
                /*                 * ********* Apply LAT & LONG   *********** */
                if (isset($condArr['u_lat']) && !empty($condArr['u_lat']) && isset($condArr['u_long']) && !empty($condArr['u_long'])) {
                    $this->db->select("tlike.status as is_like,AVG(rat.rating) as hospital_rating,tm_hospital.hospital_id,tm_hospital.hospital_latitude,tm_hospital.hospital_longitude,tm_hospital.hospital_name,tm_hospital.hospital_address,tm_hospital.hospital_number,tm_hospital.hospital_email,tm_hospital.hospital_timing,tm_hospital.hospital_image,tm_hospital.hospital_description, ( 3959 * acos( cos( radians(" . $condArr['u_lat'] . ") ) * cos( radians( tm_hospital.hospital_latitude ) )* cos( radians( tm_hospital.hospital_longitude ) - radians(" . $condArr['u_long'] . ") ) + sin( radians(" . $condArr['u_lat'] . ") ) * sin(radians(tm_hospital.hospital_latitude)) ) ) AS distance");
                    $this->db->group_by('tm_hospital.hospital_id');
                }
                /*                 * ********* Apply service_id filter   *********** */
                if (isset($condArr['hospital_id']) && !empty($condArr['hospital_id'])) {
                    $this->db->where("tm_hospital.hospital_id='" . $condArr['hospital_id'] . "'");
                }
            }
        } catch (\Exception $err) { /*         * * Do Nothing */
        }
        $query = $this->db->get();
        //echo $this->db->last_query();die;
        $returnArr = $query->row_array();
        return $returnArr;
    }

    public function findHospitalDepatment($condArr = array()) {
        try {
            $query = $this->db->from($this->table_name);

            $this->db->join('tm_hospital_department AS thd', 'thd.hospital_id = tm_hospital.hospital_id', 'INNER');
            $this->db->join('tm_department AS td', 'td.dept_id = thd.dept_id', 'INNER');
            if (isset($condArr) && is_array($condArr) && count($condArr)) {
                /*                 * ********* Apply LAT & LONG   *********** */
                $this->db->select("td.dept_id, td.dept_name, td.dept_image");
                $this->db->group_by('tm_hospital.hospital_id');
            }
            /*             * ********* Apply service_id filter   *********** */
            if (isset($condArr['hospital_id']) && !empty($condArr['hospital_id'])) {
                $this->db->where("tm_hospital.hospital_id='" . $condArr['hospital_id'] . "'");
            }
        } catch (\Exception $err) { /*         * * Do Nothing */
        }
        $query = $this->db->get();
        $returnArr = $query->result_array();
        return $returnArr;
    }

    public function findHospitalService($condArr = array()) {
        try {
            $query = $this->db->from($this->table_name);
            $this->db->join('tm_hospital_services AS ths', 'ths.hospital_id = tm_hospital.hospital_id', 'INNER');
            $this->db->join('tm_services AS ts', 'ts.service_id = ths.service_id', 'INNER');
            if (isset($condArr) && is_array($condArr) && count($condArr)) {
                /*                 * ********* Apply LAT & LONG   *********** */
                $this->db->select("ts.service_id, ts.service_name, ts.service_image");
                $this->db->group_by('tm_hospital.hospital_id');
            }
            /*             * ********* Apply service_id filter   *********** */
            if (isset($condArr['hospital_id']) && !empty($condArr['hospital_id'])) {
                $this->db->where("tm_hospital.hospital_id='" . $condArr['hospital_id'] . "'");
            }
        } catch (\Exception $err) { /*         * * Do Nothing */
        }
        $query = $this->db->get();
        $returnArr = $query->result_array();
        return $returnArr;
    }

    public function findHospitalDoctor($condArr = array()) {
        try {
            $query = $this->db->from($this->table_name);
            $this->db->join('tm_hospital_doctor AS thdoc', 'thdoc.hospital_id = tm_hospital.hospital_id', 'INNER');
            $this->db->join('tm_user AS tu', 'tu.user_id = thdoc.doctor_id and u_user_type=2', 'INNER');
            if (isset($condArr) && is_array($condArr) && count($condArr)) {
                /*                 * ********* Apply LAT & LONG   *********** */
                $this->db->select("tu.user_id,tu.u_name,tu.u_image");
                $this->db->group_by('tm_hospital.hospital_id');
            }
            /*             * ********* Apply service_id filter   *********** */
            if (isset($condArr['hospital_id']) && !empty($condArr['hospital_id'])) {
                $this->db->where("tm_hospital.hospital_id='" . $condArr['hospital_id'] . "'");
            }
        } catch (\Exception $err) { /*         * * Do Nothing */
        }
        $query = $this->db->get();
        $returnArr = $query->result_array();
        return $returnArr;
    }

//    public function findHospitalDetails($condArr = array()) {
//        try {
//            $query = $this->db->from($this->table_name);
//            $this->db->join('tm_hospital_department AS thd', 'thd.hospital_id = tm_hospital.hospital_id', 'LEFT');
//            $this->db->join('tm_department AS td', 'td.dept_id = thd.dept_id', 'LEFT');
//            
//            $this->db->join('tm_hospital_services AS ths', 'ths.hospital_id = tm_hospital.hospital_id', 'LEFT');
//            $this->db->join('tm_services AS ts', 'ts.service_id = ths.service_id', 'LEFT');
//            
//            $this->db->join('tm_hospital_doctor AS thdoc', 'thdoc.hospital_id = tm_hospital.hospital_id', 'LEFT');
//            $this->db->join('tm_user AS tu', 'tu.user_id = thdoc.doctor_id and u_user_type=2', 'LEFT');
//            if (isset($condArr) && is_array($condArr) && count($condArr)) {
//                /*********** Apply LAT & LONG   ************/
//                if (isset($condArr['u_lat']) && !empty($condArr['u_lat']) && isset($condArr['u_long']) && !empty($condArr['u_long'])) {
//                    $this->db->select("GROUP_CONCAT(DISTINCT(CONCAT(tm_hospital.hospital_name, '/', tm_hospital.hospital_address, '/', tm_hospital.hospital_number,'/',tm_hospital.hospital_email,'/',tm_hospital.hospital_timing,'/',tm_hospital.hospital_image,'/',tm_hospital.hospital_description, ''))) as hospital,GROUP_CONCAT(DISTINCT(CONCAT(td.dept_id, '/', td.dept_name, '/', td.dept_image, ''))) as department, GROUP_CONCAT(DISTINCT(CONCAT(ts.service_id, '/', ts.service_name, '/', ts.service_image, ''))) as service, GROUP_CONCAT(DISTINCT(CONCAT(tu.user_id, '/', tu.u_name, '/', tu.email, '/', tu.u_fb_id, '/', tu.u_country_code, '/', tu.u_mobile, '/', tu.u_dob, '/', tu.u_gender, '/', tu.u_user_type, '/', tu.country, '/', tu.state, '/', tu.city, '/', tu.u_region, '/', tu.u_address, '/', tu.user_fee, '/', tu.user_desc, '/', tu.u_image, '/', tu.u_lat, '/', tu.u_long, '/', tu.u_language, '/', tu.u_access_token, '/', tu.u_device_type, '/', tu.u_device_token, '/', ''))) as user, ( 3959 * acos( cos( radians(".$condArr['u_lat'].") ) * cos( radians( tm_hospital.hospital_latitude ) )* cos( radians( tm_hospital.hospital_longitude ) - radians(".$condArr['u_long'].") ) + sin( radians(" . $condArr['u_lat'] . ") ) * sin(radians(tm_hospital.hospital_latitude)) ) ) AS distance");
//                    //$this->db->select("tm_hospital.*, td.*, ts.*, ( 3959 * acos( cos( radians(".$condArr['u_lat'].") ) * cos( radians( tm_hospital.hospital_latitude ) )* cos( radians( tm_hospital.hospital_longitude ) - radians(".$condArr['u_long'].") ) + sin( radians(" . $condArr['u_lat'] . ") ) * sin(radians(tm_hospital.hospital_latitude)) ) ) AS distance");
//                    //$this->db->having('distance < 100'); // 100 miled default
//                    $this->db->group_by('tm_hospital.hospital_id'); 
//                }
//                /*********** Apply service_id filter   ************/
//                if (isset($condArr['hospital_id']) && !empty($condArr['hospital_id'])) {
//                    $this->db->where("tm_hospital.hospital_id='".$condArr['hospital_id']."'");
//                }
//            }
//        }
//        catch (\Exception $err) { /*** Do Nothing */}
//        $query = $this->db->get();
//        //echo $this->db->last_query();die;
//        $returnArr = $query->row();
//        return $returnArr;
//    }
//    
    /*
     * Function for get only language by user_id
     */
    public function getUserLanguage($user_id = 0) {
        if ($user_id > 0) {
            $this->db->column(array('u_language'));
            $query = $this->db->get_where($this->table_name, array('user_id' => $user_id));
            $returnObj = $query->row();
            return $returnObj;
        }
    }

    /*
     * Function for count near hospoital
     */
    /*
     * Function for fetch hospitals details
     */

    public function countNearHospitals($condArr = array()) {
        try {
            $query = $this->db->from($this->table_name);
            $this->db->join('tm_hospital_department AS thd', 'thd.hospital_id = tm_hospital.hospital_id', 'LEFT');
            $this->db->join('tm_hospital_services AS ths', 'ths.hospital_id = tm_hospital.hospital_id', 'LEFT');
            //$this->db->join('tm_like AS tlike', 'tlike.liking_id = tm_hospital.hospital_id and tlike.user_id = '.$condArr['user_id'].' and tlike.liking_type = 1 and tlike.status=1', 'LEFT');
            //$this->db->join('tm_rating AS rat', 'rat.product_rating_id = tm_hospital.hospital_id and rat.product_type = 1 and rat.status=1', 'LEFT');

            if (isset($condArr) && is_array($condArr) && count($condArr)) {
                /*                 * ********* Apply LAT & LONG   *********** */
                if (isset($condArr['u_lat']) && !empty($condArr['u_lat']) && isset($condArr['u_long']) && !empty($condArr['u_long'])) {
                    $this->db->select("( 3959 * acos( cos( radians(" . $condArr['u_lat'] . ") ) * cos( radians( tm_hospital.hospital_latitude ) )* cos( radians( tm_hospital.hospital_longitude ) - radians(" . $condArr['u_long'] . ") ) + sin( radians(" . $condArr['u_lat'] . ") ) * sin(radians(tm_hospital.hospital_latitude)) ) ) AS distance");
                    if (isset($condArr['radius']) && !empty($condArr['radius'])) {
                        $this->db->having('distance < ' . $condArr['radius']); // 100 miled default
                    } else {
                        $this->db->having('distance < 101'); // 100 miled default
                    }
                    $this->db->group_by('tm_hospital.hospital_id');
                }
                /*                 * ********* Apply service_id filter   *********** */
                if (isset($condArr['service_id']) && !empty($condArr['service_id'])) {
                    $this->db->where_in('ths.service_id', $condArr['service_id']);
                }
                /*                 * ********* Apply dept_id filter   *********** */
                if (isset($condArr['dept_id']) && !empty($condArr['dept_id'])) {
                    $this->db->where_in('thd.dept_id', $condArr['dept_id']);
                }
                /*                 * ********* Apply search by hospital name filter   *********** */
                if (isset($condArr['search']) && !empty($condArr['search'])) {
                    $this->db->where('tm_hospital.hospital_name like "%' . $condArr['search'] . '%" ');
                }
//                if (isset($condArr['page'])) {
//                    if($condArr['page'] == 0){
//                        $this->db->limit(10, $condArr['page']);
//                    }else{
//                        $this->db->limit(10, $condArr['page'] * 10);
//                    }
//                    
//                }
//                if (isset($condArr['sort']) && !empty($condArr['sort'])) {
//                    $expSortArr = explode(',', $condArr['sort']);
//                    if(isset($expSortArr) && is_array($expSortArr) && count($expSortArr)){
//                        $this->db->order_by($expSortArr[0], $expSortArr[1]);
//                    }
//                }
            }
        } catch (\Exception $err) { /*         * * Do Nothing */
        }
        $query = $this->db->get();
        //echo $this->db->last_query();die;
        $returnArr = $query->result_array();
        return $returnArr;
    }

    /*
     * Function for fetch hospital count
     * 
     */

    public function totalHospitalCount() {
        try {
            $this->db->select("COUNT(*) as rows");
            $query = $this->db->from($this->table_name);
        } catch (\Exception $err) { /*         * * Do Nothing */
        }
        $query = $this->db->get();
        return $query->row();
    }

    /*
     * Function for fetching hospital list data
     * 
     */

    public function fetch_admin_hospital_list($limit = '', $start = '', $condition = array()) {
        try {

            $this->db->from($this->table_name);
//            
//            $this->db->where('tm_department.status !=',3);
//            if (!empty($condition)) {
//
//                if (isset($condition['dept_name']) && isset($condition['status'])) {
//                    $this->db->where(array('dept_name ' => $condition['dept_name'], 'status ' => $condition['status']));
//                } else if (isset($condition['dept_name']) && !isset($condition['status'])) {
//
//                    $this->db->where('dept_name', $condition['dept_name']);
//                } elseif (!isset($condition['dept_name']) && isset($condition['status'])) {
//
//                    $this->db->where('status', $condition['status']);
//                }
            if (isset($condition['hospital_name']) && $condition['hospital_name'] != '') {

                $this->db->like('hospital_name', $condition['hospital_name'], 'after');
                $this->db->or_like('hospital_name', " " . $condition['hospital_name']);
            }
            if (isset($condition['sort_by']) && isset($condition['sort_order'])){
                  $sort_by =  $condition['sort_by'];
                  $sort_order = $condition['sort_order'];
              }
               else{
                     $sort_by = "hospital_name";
                     $sort_order = "ASC";
              }
//            }
//            $this->db->group_by('tm_department.dept_id');
            $this->db->order_by('tm_hospital.'.$sort_by,  $sort_order);
            if (isset($limit) and isset($start)) {
                $this->db->limit($limit, $start);
            }
        } catch (Exception $e) {
            
        }
        $query = $this->db->get();
        //echo $this->db->last_query();die;
        $result = $query->result_array();

        if (count($result) > 0) {
            return $result;
        } else {
            return array();
        }
    }

    public function validation() {
        return array(
            array(
                'field' => 'hospital_name',
                'label' => 'Hospital Name',
                'rules' => 'required|trim'
            ),
            array(
                'field' => 'email',
                'label' => 'Email',
                'rules' => 'required|trim|valid_email'
            ),
            array(
                'field' => 'password',
                'label' => 'Password',
                'rules' => 'required|trim'
            ),
            array(
                'field' => 'mob_num',
                'label' => 'Mobile Number',
                'rules' => 'required|trim'
            ),
            array(
                'field' => 'location',
                'label' => 'Location',
                'rules' => 'required|trim'
            ),
            array(
                'field' => 'admin_name',
                'label' => 'Admin Name',
                'rules' => 'required|trim',
            ),
            array(
                'field' => 'term_n_con',
                'label' => 'Terms and condition',
                'rules' => 'required',
            ),
            array(
                'field' => 'lat',
                'label' => 'Location',
                'rules' => 'required',
                'errors' => array(
                    'required' => 'Please type in location again',
                )
            ),
            array(
                'field' => 'long',
                'label' => 'Location',
                'rules' => 'required',
                'errors' => array(
                    'required' => 'Please type in location again',
                )
            ),
            array(
                'field' => 'owner_name_on',
                'label' => 'Owner name 1',
                'rules' => 'required'
            ),
        );
    }

}

//end of class here
